/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds;

import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.pavocado.exoticbirds.ExoticBirdsMod;
import net.pavocado.exoticbirds.block.BlockBirdcage;
import net.pavocado.exoticbirds.capabilities.BirdTracking;
import net.pavocado.exoticbirds.capabilities.BirdTrackingStorage;
import net.pavocado.exoticbirds.capabilities.IBirdStorage;
import net.pavocado.exoticbirds.config.ConfigHolder;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsFeatures;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSpawning;
import net.pavocado.exoticbirds.item.ItemBirdEgg;
import net.pavocado.exoticbirds.item.ItemBirdcage;
import net.pavocado.exoticbirds.item.ItemModSpawnEgg;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="exoticbirds", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEventSubscriber {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IBirdStorage.class, (Capability.IStorage)new BirdTrackingStorage(), BirdTracking::new);
        HashSet biomeSet = new HashSet();
        biomeSet.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE));
        biomeSet.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SAVANNA));
        biomeSet.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.FOREST));
        biomeSet.addAll(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SWAMP));
        biomeSet.forEach(biome -> biome.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, ((Feature)ExoticBirdsFeatures.NEST.get()).func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(2, 0.1f, 1)))));
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        ExoticBirdsBlocks.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            Item.Properties properties = new Item.Properties().func_200916_a(ExoticBirdsMod.TAB_EB_ALL);
            BlockItem blockItem = block instanceof BlockBirdcage ? new ItemBirdcage((Block)block, properties.func_200917_a(1)) : new BlockItem(block, properties);
            blockItem.setRegistryName(block.getRegistryName());
            registry.register((IForgeRegistryEntry)blockItem);
        });
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            ExoticBirdsConfig.bakeClient(config);
        } else if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            ExoticBirdsConfig.bakeServer(config);
            ExoticBirdsSpawning.registerSpawns();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPostRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        ((ItemBirdEgg)ExoticBirdsItems.FLAMINGO_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.FLAMINGO.get()));
        ((ItemBirdEgg)ExoticBirdsItems.BOOBY_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.BOOBY.get()));
        ((ItemBirdEgg)ExoticBirdsItems.OWL_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.OWL.get()));
        ((ItemBirdEgg)ExoticBirdsItems.PEAFOWL_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.PEAFOWL.get()));
        ((ItemBirdEgg)ExoticBirdsItems.BLUEJAY_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.BLUEJAY.get()));
        ((ItemBirdEgg)ExoticBirdsItems.CARDINAL_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.CARDINAL.get()));
        ((ItemBirdEgg)ExoticBirdsItems.ROBIN_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.ROBIN.get()));
        ((ItemBirdEgg)ExoticBirdsItems.CRANE_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.CRANE.get()));
        ((ItemBirdEgg)ExoticBirdsItems.HERON_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.HERON.get()));
        ((ItemBirdEgg)ExoticBirdsItems.LYREBIRD_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.LYREBIRD.get()));
        ((ItemBirdEgg)ExoticBirdsItems.KIWI_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.KIWI.get()));
        ((ItemBirdEgg)ExoticBirdsItems.TOUCAN_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.TOUCAN.get()));
        ((ItemBirdEgg)ExoticBirdsItems.BUDGERIGAR_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.BUDGERIGAR.get()));
        ((ItemBirdEgg)ExoticBirdsItems.CASSOWARY_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.CASSOWARY.get()));
        ((ItemBirdEgg)ExoticBirdsItems.COCKATOO_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.COCKATOO.get()));
        ((ItemBirdEgg)ExoticBirdsItems.DUCK_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.DUCK.get()));
        ((ItemBirdEgg)ExoticBirdsItems.GOULDIANFINCH_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.GOULDIANFINCH.get()));
        ((ItemBirdEgg)ExoticBirdsItems.GULL_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.GULL.get()));
        ((ItemBirdEgg)ExoticBirdsItems.HUMMINGBIRD_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.HUMMINGBIRD.get()));
        ((ItemBirdEgg)ExoticBirdsItems.KINGFISHER_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.KINGFISHER.get()));
        ((ItemBirdEgg)ExoticBirdsItems.KOOKABURRA_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.KOOKABURRA.get()));
        ((ItemBirdEgg)ExoticBirdsItems.MAGPIE_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.MAGPIE.get()));
        ((ItemBirdEgg)ExoticBirdsItems.OSTRICH_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.OSTRICH.get()));
        ((ItemBirdEgg)ExoticBirdsItems.PELICAN_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.PELICAN.get()));
        ((ItemBirdEgg)ExoticBirdsItems.PENGUIN_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.PENGUIN.get()));
        ((ItemBirdEgg)ExoticBirdsItems.MACAW_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.MACAW.get()));
        ((ItemBirdEgg)ExoticBirdsItems.PIGEON_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.PIGEON.get()));
        ((ItemBirdEgg)ExoticBirdsItems.ROADRUNNER_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.ROADRUNNER.get()));
        ((ItemBirdEgg)ExoticBirdsItems.SWAN_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.SWAN.get()));
        ((ItemBirdEgg)ExoticBirdsItems.WOODPECKER_EGG.get()).initType((EntityType<? extends EntityAbstractBird>)((EntityType)ExoticBirdsEntities.WOODPECKER.get()));
        ItemModSpawnEgg.initUnaddedEggs();
    }
}

