/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsTileEntities;
import net.pavocado.exoticbirds.tileentity.TileEntityNest;

public class BlockNest
extends ContainerBlock {
    public static final IntegerProperty EGGS_0_3;
    public static final IntegerProperty EGGS;
    public static final DirectionProperty FACING;
    public static final VoxelShape NEST_SHAPE;

    public BlockNest(Block.Properties blockPropertiesIn) {
        super(blockPropertiesIn);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)EGGS, (Comparable)Integer.valueOf(0)));
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return NEST_SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return NEST_SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return NEST_SHAPE;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{EGGS, FACING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)))).func_206870_a((IProperty)EGGS, state.func_177229_b((IProperty)EGGS));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)EGGS, state.func_177229_b((IProperty)EGGS));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)ExoticBirdsTileEntities.NEST.get()).func_200968_a();
    }

    public void func_196243_a(BlockState oldState, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tileEntity;
        if (oldState.func_177230_c() != newState.func_177230_c() && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityNest) {
            ItemStackHandler inventory = ((TileEntityNest)tileEntity).inventory;
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)inventory.getStackInSlot(slot));
            }
        }
        super.func_196243_a(oldState, worldIn, pos, newState, isMoving);
    }

    public ActionResultType func_225533_a_(BlockState stateIn, World worldIn, BlockPos posIn, PlayerEntity playerIn, Hand handIn, BlockRayTraceResult hitIn) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(posIn);
        if (tileEntity instanceof TileEntityNest) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)((TileEntityNest)tileEntity), (BlockPos)posIn);
        }
        return ActionResultType.SUCCESS;
    }

    @Deprecated
    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityNest) {
            return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((TileEntityNest)tileEntity).inventory);
        }
        return super.func_180641_l(blockState, worldIn, pos);
    }

    public boolean func_149653_t(BlockState state) {
        return ExoticBirdsConfig.allowNestEggRegen;
    }

    public void tick(BlockState state, World worldIn, BlockPos pos, Random random) {
        TileEntity tileEntity;
        if (random.nextInt(50) == 0 && (Integer)state.func_177229_b((IProperty)EGGS) < 3 && (tileEntity = worldIn.func_175625_s(pos)) instanceof TileEntityNest) {
            TileEntityNest tileEntityNest = (TileEntityNest)tileEntity;
            for (int k = 0; k < 3; ++k) {
                if (tileEntityNest.inventory.getStackInSlot(k) != ItemStack.field_190927_a) continue;
                tileEntityNest.inventory.setStackInSlot(k, new ItemStack((IItemProvider)ExoticBirdsItems.MYSTERY_EGG.get(), 1));
                break;
            }
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canBlockStay(worldIn, pos, this.func_176223_P())) {
            worldIn.func_175655_b(new BlockPos((Vec3i)pos), true);
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
    }

    public boolean canBlockStay(World worldIn, BlockPos pos, BlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            return worldIn.func_180495_p(pos.func_177977_b()).func_185904_a().func_76220_a();
        }
        return false;
    }

    static {
        EGGS = EGGS_0_3 = IntegerProperty.func_177719_a((String)"eggs", (int)0, (int)3);
        FACING = HorizontalBlock.field_185512_D;
        NEST_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    }
}

