/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;
import net.pavocado.exoticbirds.client.gui.ScreenBirdBook;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;

public class CachedEntry {
    private EntityAbstractBird cachedEntity;
    private ItemStack birdEgg;
    private List<BirdVariantEntry> birdVariants = Lists.newArrayList();
    private BirdVariantEntry currentVariant;
    private int discoveredVariants;
    private String familyName;
    private List<Biome> biomeList = Lists.newArrayList();
    private List<ItemStack> breedingItems = Lists.newArrayList();
    private List<ItemStack> tamingItems = Lists.newArrayList();

    public CachedEntry(EntityAbstractBird birdEntity) {
        this.cachedEntity = birdEntity;
        if (birdEntity != null) {
            this.birdEgg = birdEntity.getEgg();
            this.birdVariants.clear();
            for (int i = 0; i < Math.max(1, birdEntity.getVariantCount()); ++i) {
                BirdVariantEntry birdEntry = new BirdVariantEntry((LivingEntity)birdEntity, i, ScreenBirdBook.isEntityUnlocked(birdEntity.func_200600_R(), i));
                if (birdEntry.unlocked) {
                    ++this.discoveredVariants;
                    if (this.currentVariant == null) {
                        this.currentVariant = birdEntry;
                    }
                }
                this.birdVariants.add(birdEntry);
            }
            if (this.currentVariant == null) {
                this.currentVariant = this.birdVariants.get(0);
            }
            this.cachedEntity.setVariant(this.currentVariant.variant);
            this.familyName = I18n.func_135052_a((String)("exoticbirds.family." + this.cachedEntity.func_200600_R().func_210760_d().replace("entity.exoticbirds.", "")), (Object[])new Object[0]);
            this.biomeList.clear();
            for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
                for (Biome.SpawnListEntry spawn : biome.func_76747_a(EntityClassification.CREATURE)) {
                    if (spawn.field_200702_b != birdEntity.func_200600_R()) continue;
                    this.biomeList.add(biome);
                }
            }
            this.tamingItems = this.cachedEntity.getTamingItems();
            this.breedingItems = this.cachedEntity.getBreedingItems();
        }
    }

    public final ItemStack getBirdEgg() {
        return this.birdEgg;
    }

    public final EntityAbstractBird getCachedEntity() {
        return this.cachedEntity;
    }

    public final BirdVariantEntry getCurrentVariant() {
        return this.currentVariant;
    }

    public void setCurrentVariant(BirdVariantEntry variantEntry) {
        if (variantEntry != null) {
            this.cachedEntity.setVariant(variantEntry.variant);
            this.currentVariant = variantEntry;
        }
    }

    public List<BirdVariantEntry> getBirdVariantList() {
        return this.birdVariants;
    }

    public int getDiscoveredVariants() {
        return this.discoveredVariants;
    }

    public String getFamilyName() {
        return this.familyName.toUpperCase();
    }

    public List<Biome> getBiomeList() {
        return this.biomeList;
    }

    public List<ItemStack> getBreedingItems() {
        return this.breedingItems;
    }

    public List<ItemStack> getTamingItems() {
        return this.tamingItems;
    }

    public class BirdVariantEntry {
        private int variant;
        private boolean unlocked;
        private String variantName;

        public BirdVariantEntry(LivingEntity entityLiving, int variant, boolean isUnlocked) {
            this.variant = variant;
            this.unlocked = isUnlocked;
            this.variantName = this.getVariantName(entityLiving, variant, isUnlocked);
        }

        private String getVariantName(LivingEntity entityLiving, int variant, boolean isUnlocked) {
            if (entityLiving instanceof EntityAbstractBird && isUnlocked) {
                return ((EntityAbstractBird)entityLiving).getTranslatedVariantName(variant, false);
            }
            return "???";
        }

        public boolean isVariantUnlocked() {
            return this.unlocked;
        }

        public String getVariantName() {
            return this.variantName;
        }
    }
}

