/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.pavocado.exoticbirds.container.ContainerIdentifier;
import net.pavocado.exoticbirds.tileentity.TileEntityIdentifier;

public class ScreenIdentifier
extends ContainerScreen<ContainerIdentifier> {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("exoticbirds", "textures/gui/container/egg_identifier.png");

    public ScreenIdentifier(ContainerIdentifier container, PlayerInventory inventory, ITextComponent title) {
        super((Container)container, inventory, title);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        String s = this.title.func_150254_d();
        this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 3), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        int startX = this.field_147003_i;
        int startY = this.field_147009_r;
        this.blit(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.isBurning()) {
            int glassHeight = this.getCookProgressScaled(23);
            this.blit(startX + 7, startY + 55 - glassHeight, 176, 78 - glassHeight, 23, glassHeight);
            int scanHeight = this.getCookProgressRapidScaled(54);
            this.blit(startX + 7, startY + 70 - scanHeight, 176, 54 - scanHeight, 23, scanHeight + 1);
            int fuelHeight = this.getBurnTimeScaled(53);
            this.blit(startX + 55, startY + 69 - fuelHeight, 199, 53 - fuelHeight, 8, fuelHeight + 1);
        }
    }

    private int getCookProgressScaled(int pixels) {
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.eggIncubateTime <= 0) {
            return 0;
        }
        return (200 - tileEntity.eggIncubateTime) * pixels / 200;
    }

    private int getCookProgressRapidScaled(int pixels) {
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.eggIncubateTime <= 0) {
            return 0;
        }
        return (200 - tileEntity.eggIncubateTime) % 50 * pixels / 50;
    }

    private int getBurnTimeScaled(int pixels) {
        TileEntityIdentifier tileEntity = ((ContainerIdentifier)this.field_147002_h).tileEntity;
        if (tileEntity.maxFuelBurnTime <= 0 || tileEntity.fuelBurnTimeLeft <= 0) {
            return 0;
        }
        return tileEntity.fuelBurnTimeLeft * pixels / tileEntity.maxFuelBurnTime;
    }
}

