/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.item.ItemBirdEgg;

public class EntityBirdEgg
extends ProjectileItemEntity {
    private static final DataParameter<ItemStack> ITEM_EGG = EntityDataManager.func_187226_a(EntityBirdEgg.class, (IDataSerializer)DataSerializers.field_187196_f);
    private final EntityType<? extends EntityAbstractBird> birdType;
    private int spawnChance = 30;
    private int variant = -1;

    public EntityBirdEgg(EntityType<? extends EntityBirdEgg> p_i50154_1_, World p_i50154_2_) {
        super(p_i50154_1_, p_i50154_2_);
        this.birdType = (EntityType)ExoticBirdsEntities.FLAMINGO.get();
    }

    public EntityBirdEgg(World worldIn, LivingEntity throwerIn, EntityType<? extends EntityAbstractBird> birdType, ItemStack birdEgg) {
        super((EntityType)ExoticBirdsEntities.BIRD_EGG.get(), throwerIn, worldIn);
        this.birdType = birdType;
        this.setSpawnChance(birdEgg);
        this.func_184212_Q().func_187227_b(ITEM_EGG, (Object)birdEgg);
    }

    public EntityBirdEgg(World worldIn, double x, double y, double z, EntityType<? extends EntityAbstractBird> birdType, ItemStack birdEgg) {
        super((EntityType)ExoticBirdsEntities.BIRD_EGG.get(), x, y, z, worldIn);
        this.birdType = birdType;
        this.setSpawnChance(birdEgg);
        this.func_184212_Q().func_187227_b(ITEM_EGG, (Object)birdEgg);
    }

    public void setSpawnChance(ItemStack itemstack) {
        CompoundNBT compoundnbt = itemstack.func_179543_a("eggValues");
        if (compoundnbt != null) {
            if (compoundnbt.func_74764_b("SpawnChance")) {
                this.spawnChance = compoundnbt.func_74762_e("SpawnChance");
            }
            if (compoundnbt.func_74764_b("Variant")) {
                this.variant = compoundnbt.func_74762_e("Variant");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 3) {
            for (int i = 0; i < 8; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184543_l()), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08, ((double)this.field_70146_Z.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            ((EntityRayTraceResult)result).func_216348_a().func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (ExoticBirdsConfig.createExoticEggshell && this.field_70146_Z.nextInt(3) == 0) {
                this.func_199701_a_(new ItemStack((IItemProvider)ExoticBirdsItems.EGGSHELL.get(), this.field_70146_Z.nextInt(2) + 1));
            }
            if (this.field_70146_Z.nextInt(100 / this.spawnChance) == 0) {
                int i = 1;
                if (this.field_70146_Z.nextInt(32) == 0) {
                    i = 4;
                }
                if (this.birdType != null) {
                    for (int j = 0; j < i; ++j) {
                        EntityAbstractBird entityBird = (EntityAbstractBird)this.birdType.func_200721_a(this.field_70170_p);
                        if (entityBird == null) continue;
                        entityBird.func_70873_a(-24000);
                        entityBird.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), SpawnReason.BREEDING, null, null);
                        entityBird.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
                        if (this.variant > -1) {
                            entityBird.setVariant(this.variant);
                            entityBird.setVariant(entityBird.getChildVariant());
                        }
                        this.field_70170_p.func_217376_c((Entity)entityBird);
                    }
                }
            }
            this.field_70170_p.func_72960_a((Entity)this, (byte)3);
            this.func_70106_y();
        }
    }

    public IPacket func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM_EGG, (Object)ItemStack.field_190927_a);
    }

    protected Item func_213885_i() {
        ItemStack itemstack = (ItemStack)this.func_184212_Q().func_187225_a(ITEM_EGG);
        if (!(itemstack.func_77973_b() instanceof ItemBirdEgg)) {
            return Items.field_151110_aK;
        }
        return itemstack.func_77973_b();
    }
}

