/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractWadingBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSounds;

public class EntityFlamingo
extends EntityAbstractWadingBird {
    private static final DataParameter<Boolean> STANDING = EntityDataManager.func_187226_a(EntityFlamingo.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY});
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_andean.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_caribbean.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_chilean.png"));
        hashMap.put(3, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_greater.png"));
        hashMap.put(4, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_james.png"));
        hashMap.put(5, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_lesser.png"));
        hashMap.put(6, new ResourceLocation("exoticbirds:textures/entity/flamingo/flamingo_greater_black.png"));
    });
    private FlamingoStand standGoal;

    public EntityFlamingo(EntityType<? extends EntityFlamingo> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.FLAMINGO_EGG.get()), BIRD_TEXTURES.size(), true, false);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.standGoal = new FlamingoStand(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)this.standGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STANDING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsFlamingo;
    }

    @Override
    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList((Object[])BREEDING_ITEMS.func_193365_a());
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_FLAMINGO_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_FLAMINGO_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_FLAMINGO_AMBIENT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 0.6f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityFlamingo createChild(AgeableEntity ageable) {
        EntityFlamingo entityFlamingo = new EntityFlamingo((EntityType<? extends EntityFlamingo>)((EntityType)ExoticBirdsEntities.FLAMINGO.get()), this.field_70170_p);
        entityFlamingo.setVariant(this.getChildVariant());
        return entityFlamingo;
    }

    public boolean getIsStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(STANDING);
    }

    public void setIsStanding(boolean isStanding) {
        this.field_70180_af.func_187227_b(STANDING, (Object)isStanding);
    }

    @Override
    public void func_70636_d() {
        if (this.getIsStanding() || this.func_70610_aX()) {
            this.field_70703_bu = false;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
        }
        super.func_70636_d();
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.getIsStanding()) {
            this.setIsStanding(false);
        }
        return super.func_70097_a(source, amount);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.9f;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74762_e("StandTime") > 0) {
            this.setIsStanding(true);
            if (this.standGoal != null) {
                this.standGoal.standTime = compound.func_74762_e("StandTime");
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("StandingBool", this.getIsStanding());
        if (this.standGoal != null) {
            compound.func_74768_a("StandTime", this.standGoal.standTime);
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        ILivingEntityData livingData = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.field_70146_Z.nextInt(80) == 0) {
            this.setVariant(6);
        } else {
            this.setVariant(this.field_70146_Z.nextInt(6));
        }
        return livingData;
    }

    public class FlamingoStand
    extends Goal {
        private final EntityFlamingo entityFlamingo;
        public int standTime;
        private int timeSinceLastStand;

        public FlamingoStand(EntityFlamingo entitylivingIn) {
            this.entityFlamingo = entitylivingIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.entityFlamingo.field_70702_br == 0.0f && this.entityFlamingo.field_70701_bs == 0.0f && this.entityFlamingo.field_191988_bg == 0.0f) {
                return this.timeSinceLastStand < this.entityFlamingo.field_70173_aa && this.entityFlamingo.func_70681_au().nextInt(400) == 1 || this.standTime > 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.standTime > 0;
        }

        public void func_75249_e() {
            this.standTime = 1000 + this.entityFlamingo.func_70681_au().nextInt(500);
            this.timeSinceLastStand = 0;
            this.entityFlamingo.setIsStanding(true);
            this.entityFlamingo.func_70661_as().func_75499_g();
            this.entityFlamingo.func_70605_aq().func_75642_a(this.entityFlamingo.func_226277_ct_(), this.entityFlamingo.func_226278_cu_(), this.entityFlamingo.func_226281_cx_(), 0.0);
        }

        public void func_75251_c() {
            this.standTime = -1;
            this.timeSinceLastStand = this.entityFlamingo.field_70173_aa + 400;
            this.entityFlamingo.setIsStanding(false);
        }

        public void func_75246_d() {
            --this.standTime;
        }
    }
}

