/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSounds;

public class EntityOstrich
extends EntityAbstractBird
implements IJumpingMount {
    private static final Ingredient BREEDING_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e, Items.field_185164_cV, Items.field_222112_pR, Items.field_221692_bh, Items.field_221694_bi});
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityOstrich.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_common_male.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/ostrich/ostrich_common_female.png"));
    });
    protected float jumpPower;
    protected boolean ostrichJumping;

    public EntityOstrich(EntityType<? extends EntityOstrich> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.OSTRICH_EGG.get()), BIRD_TEXTURES.size(), false, true);
        this.field_70138_W = 1.0f;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.hasChildTextures = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.4));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, BREEDING_ITEMS, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsOstrich;
    }

    @Override
    public List<ItemStack> getBreedingItems() {
        return Lists.newArrayList((Object[])BREEDING_ITEMS.func_193365_a());
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof PlayerEntity;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_OSTRICH_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)ExoticBirdsSounds.ENTITY_OSTRICH_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.2f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public EntityOstrich createChild(AgeableEntity ageable) {
        EntityOstrich entityOstrich = new EntityOstrich((EntityType<? extends EntityOstrich>)((EntityType)ExoticBirdsEntities.OSTRICH.get()), this.field_70170_p);
        entityOstrich.setVariant(this.getChildVariant());
        return entityOstrich;
    }

    public boolean func_70877_b(ItemStack stack) {
        return BREEDING_ITEMS.test(stack);
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Saddle", this.getSaddled());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (this.getSaddled()) {
            if (jumpPowerIn < 0) {
                jumpPowerIn = 0;
            }
            if (jumpPowerIn > 0) {
                this.jumpPower = 1.0f;
            }
        }
    }

    public void func_184777_r_() {
    }

    public void func_184775_b(int p_184775_1_) {
    }

    public boolean func_184776_b() {
        return this.getSaddled();
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.9f;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!super.func_184645_a(player, hand)) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_77973_b() == Items.field_151057_cb) {
                itemstack.func_111282_a(player, (LivingEntity)this, hand);
                return true;
            }
            if (this.getSaddled() && !this.func_184207_aI()) {
                if (itemstack.func_77973_b() == Items.field_151097_aZ) {
                    this.setSaddled(false);
                    if (!this.field_70170_p.func_201670_d()) {
                        this.func_199703_a((IItemProvider)Items.field_151141_av);
                        itemstack.func_222118_a(1, (LivingEntity)player, e -> e.func_213334_d(hand));
                        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
                    }
                } else if (!this.field_70170_p.func_201670_d() && ExoticBirdsConfig.ostrichRiding) {
                    player.func_184220_m((Entity)this);
                }
                return true;
            }
            if (itemstack.func_77973_b() == Items.field_151141_av) {
                if (this.func_70089_S() && !this.getSaddled() && !this.func_70631_g_()) {
                    this.setSaddled(true);
                    this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                    itemstack.func_190918_g(1);
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.getSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public double func_70042_X() {
        return super.func_70042_X() - 0.45;
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public boolean isOstrichJumping() {
        return this.ostrichJumping;
    }

    public void setOstrichJumping(boolean jumping) {
        this.ostrichJumping = jumping;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public void func_213352_e(Vec3d velocity) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF()) {
                double d0;
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.jumpPower > 0.0f && !this.isOstrichJumping() && this.field_70122_E) {
                    double d02 = (double)this.jumpPower * (double)0.6f;
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d02 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d02;
                    Vec3d vec3d = this.func_213322_ci();
                    this.func_213293_j(vec3d.field_72450_a, d1, vec3d.field_72449_c);
                    this.setOstrichJumping(true);
                    this.field_70160_al = true;
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-0.2f * f2 * this.jumpPower), 0.0, (double)(0.2f * f3 * this.jumpPower)));
                    }
                    this.jumpPower = 0.0f;
                }
                this.field_70747_aH = this.func_70689_ay() * 0.5f;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.7f);
                    super.func_213352_e(new Vec3d((double)f, velocity.field_72448_b, (double)f1));
                } else {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.jumpPower = 0.0f;
                    this.setOstrichJumping(false);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.func_226277_ct_() - this.field_70169_q;
                float f3 = MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * 4.0f;
                if (f3 > 1.0f) {
                    f3 = 1.0f;
                }
                this.field_70721_aZ += (f3 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70747_aH = 0.02f;
                super.func_213352_e(velocity);
            }
        }
    }
}

