/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.entity;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsEntities;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsSounds;

public class EntityWoodpecker
extends EntityAbstractBird {
    private static final DataParameter<Boolean> HANGING = EntityDataManager.func_187226_a(EntityWoodpecker.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final Map<Integer, ResourceLocation> BIRD_TEXTURES = (Map)Util.func_200696_a((Object)Maps.newHashMap(), hashMap -> {
        hashMap.put(0, new ResourceLocation("exoticbirds:textures/entity/woodpecker/woodpecker_greater.png"));
        hashMap.put(1, new ResourceLocation("exoticbirds:textures/entity/woodpecker/woodpecker_green.png"));
        hashMap.put(2, new ResourceLocation("exoticbirds:textures/entity/woodpecker/woodpecker_pileated.png"));
    });
    private static final EntityPredicate NEAREST_ENTITY = new EntityPredicate().func_221013_a(4.0).func_221011_b();
    private BlockPos spawnPosition;
    private boolean isPecking = false;
    private float timeIsPecking;
    private float prevTimeIsPecking;

    public EntityWoodpecker(EntityType<? extends EntityWoodpecker> type, World worldIn) {
        super(type, worldIn, new ItemStack((IItemProvider)ExoticBirdsItems.WOODPECKER_EGG.get()), BIRD_TEXTURES.size(), true, false);
        this.setIsHanging(true);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HANGING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.0);
    }

    @Override
    protected Map<Integer, ResourceLocation> getEntityTextures() {
        return BIRD_TEXTURES;
    }

    @Override
    public List<String> getBlacklistedDimensions() {
        return ExoticBirdsConfig.blacklistedDimensionsWoodpecker;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return ExoticBirdsEntities.FLYING_BIRD;
    }

    protected SoundEvent func_184639_G() {
        if (this.getIsHanging()) {
            return null;
        }
        return (SoundEvent)ExoticBirdsSounds.ENTITY_WOODPECKER_AMBIENT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public boolean getIsHanging() {
        return (Boolean)this.field_70180_af.func_187225_a(HANGING);
    }

    protected void setIsHanging(boolean isHanging) {
        this.field_70180_af.func_187227_b(HANGING, (Object)isHanging);
        if (!isHanging) {
            this.isPecking = false;
            this.prevTimeIsPecking = 0.0f;
            this.timeIsPecking = 0.0f;
        }
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.getIsHanging() && !this.isPecking && this.field_70146_Z.nextInt(200) == 0) {
            this.isPecking = true;
            this.timeIsPecking = 0.0f;
            this.prevTimeIsPecking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        Vec3d motion = Vec3d.field_186680_a;
        if (!this.getIsHanging()) {
            motion = this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0);
        } else {
            this.func_226288_n_((double)MathHelper.func_76128_c((double)this.func_226277_ct_()) + 0.5, this.func_226278_cu_(), (double)MathHelper.func_76128_c((double)this.func_226281_cx_()) + 0.5);
        }
        this.func_213317_d(motion);
        if (this.isPecking) {
            if (this.timeIsPecking == 0.0f) {
                this.func_184185_a((SoundEvent)ExoticBirdsSounds.ENTITY_WOODPECKER_PECK.get(), this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeIsPecking = this.timeIsPecking;
            this.timeIsPecking += 0.05f;
            if (this.prevTimeIsPecking >= 2.0f) {
                this.isPecking = false;
                this.prevTimeIsPecking = 0.0f;
                this.timeIsPecking = 0.0f;
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        this.isPecking = false;
        this.prevTimeIsPecking = 0.0f;
        this.timeIsPecking = 0.0f;
        super.func_70645_a(cause);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getPeckAngle(float partialTick, float offset) {
        float f = (MathHelper.func_219799_g((float)partialTick, (float)this.prevTimeIsPecking, (float)this.timeIsPecking) + offset) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 15.0f)) * 0.15f * (float)Math.PI - 1.802233f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isPecking = true;
            this.timeIsPecking = 0.0f;
            this.prevTimeIsPecking = 0.0f;
        } else {
            super.func_70103_a(id);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        if (this.getIsHanging()) {
            BlockPos treePos = this.getTreeLocation();
            if (treePos != null) {
                this.func_70671_ap().func_75650_a((double)treePos.func_177958_n() + 0.5, (double)treePos.func_177956_o(), (double)treePos.func_177952_p() + 0.5, 10.0f, (float)this.func_70646_bf());
                if (this.field_70170_p.func_217370_a(NEAREST_ENTITY, (LivingEntity)this) != null) {
                    this.setIsHanging(false);
                    this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
                }
            } else {
                this.setIsHanging(false);
                this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218137_a((IPosition)this.func_213303_ch(), 2.0)) {
                this.spawnPosition = new BlockPos(this.func_226277_ct_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7), this.func_226278_cu_() + (double)this.field_70146_Z.nextInt(6) - 2.0, this.func_226281_cx_() + (double)this.field_70146_Z.nextInt(7) - (double)this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            Vec3d vec3d = this.func_213322_ci();
            Vec3d vec3d1 = vec3d.func_72441_c((Math.signum(d0) * 0.5 - vec3d.field_72450_a) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.field_72448_b) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.field_72449_c) * (double)0.1f);
            this.func_213317_d(vec3d1);
            float f = (float)(MathHelper.func_181159_b((double)vec3d1.field_72449_c, (double)vec3d1.field_72450_a) * 57.2957763671875) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.5f;
            this.field_70177_z += f1;
            BlockPos treePos = this.getTreeLocation();
            if (this.field_70146_Z.nextInt(50) == 0 && treePos != null) {
                this.setIsHanging(true);
            }
        }
    }

    public EntityWoodpecker createChild(AgeableEntity ageable) {
        EntityWoodpecker entityWoodpecker = new EntityWoodpecker((EntityType<? extends EntityWoodpecker>)((EntityType)ExoticBirdsEntities.WOODPECKER.get()), this.field_70170_p);
        entityWoodpecker.setVariant(this.getChildVariant());
        return entityWoodpecker;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (HANGING.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        if (this.getIsHanging()) {
            return super.func_213305_a(poseIn).func_220312_a(0.7f, 1.7f);
        }
        return super.func_213305_a(poseIn);
    }

    public BlockPos getTreeLocation() {
        BlockPos[] pos;
        BlockPos blockpos = new BlockPos((Entity)this);
        for (BlockPos currentBlock : pos = new BlockPos[]{blockpos, blockpos.func_177978_c(), blockpos.func_177974_f(), blockpos.func_177968_d(), blockpos.func_177976_e()}) {
            BlockState blockState = this.field_70170_p.func_180495_p(currentBlock);
            if (!blockState.func_215686_e((IBlockReader)this.field_70170_p, currentBlock) || !BlockTags.field_200031_h.func_199685_a_((Object)blockState.func_177230_c())) continue;
            return currentBlock;
        }
        return null;
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setIsHanging(compound.func_74767_n("HangingBool"));
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("HangingBool", this.getIsHanging());
    }
}

