/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.PacketDistributor;
import net.pavocado.exoticbirds.block.BlockBirdcage;
import net.pavocado.exoticbirds.capabilities.BirdTrackingProvider;
import net.pavocado.exoticbirds.capabilities.IBirdStorage;
import net.pavocado.exoticbirds.client.gui.ScreenBirdBook;
import net.pavocado.exoticbirds.entity.EntityAbstractBird;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketLogBird;
import net.pavocado.exoticbirds.network.PacketLogBirdcage;
import net.pavocado.exoticbirds.network.PacketSyncCapabilities;
import net.pavocado.exoticbirds.tileentity.TileEntityBirdcage;

public class ItemBirdBook
extends Item {
    public ItemBirdBook(Item.Properties builder) {
        super(builder);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ItemBirdBook.displayGUIScreen(worldIn, playerIn));
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void displayGUIScreen(World worldIn, PlayerEntity playerIn) {
        if (worldIn.field_72995_K) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ScreenBirdBook(playerIn));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        if (blockstate.func_177230_c() instanceof BlockBirdcage) {
            PlayerEntity player;
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity tileEntity = world.func_175625_s(blockpos);
            if (tileEntity instanceof TileEntityBirdcage && (player = context.func_195999_j()) != null) {
                ItemBirdBook.logBirdcage(player, (TileEntityBirdcage)tileEntity);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!attacker.field_70170_p.field_72995_K && attacker instanceof PlayerEntity) {
            ItemBirdBook.logBird((PlayerEntity)attacker, target);
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, PlayerEntity playerIn, LivingEntity target, Hand hand) {
        if (!playerIn.field_70170_p.field_72995_K) {
            ItemBirdBook.logBird(playerIn, target);
        }
        return true;
    }

    private static void logBird(PlayerEntity playerIn, LivingEntity target) {
        if (!playerIn.field_70170_p.field_72995_K) {
            playerIn.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                if (target instanceof EntityAbstractBird) {
                    boolean isNewEntry = ItemBirdBook.canBirdBeStoredInCapabilites(cap, playerIn, (EntityAbstractBird)target);
                    ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerIn), (Object)new PacketLogBird(target.func_145782_y(), isNewEntry));
                } else {
                    playerIn.func_145747_a(new TranslationTextComponent("book.exoticbirds.log_fail", new Object[0]).func_211708_a(TextFormatting.RED));
                }
            });
        }
    }

    private static void logBirdcage(PlayerEntity playerIn, TileEntityBirdcage tileEntityBirdcage) {
        if (!playerIn.field_70170_p.field_72995_K) {
            playerIn.getCapability(BirdTrackingProvider.BIRD_TRACKING_CAPABILITY).ifPresent(cap -> {
                Entity target = tileEntityBirdcage.getBirdcageLogic().getLoggedEntity();
                if (target instanceof EntityAbstractBird) {
                    boolean isNewEntry = ItemBirdBook.canBirdBeStoredInCapabilites(cap, playerIn, (EntityAbstractBird)target);
                    ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerIn), (Object)new PacketLogBirdcage(tileEntityBirdcage.func_174877_v(), isNewEntry));
                } else if (target instanceof LivingEntity) {
                    playerIn.func_145747_a(new TranslationTextComponent("book.exoticbirds.log_fail", new Object[0]).func_211708_a(TextFormatting.RED));
                } else {
                    playerIn.func_145747_a(new TranslationTextComponent("book.exoticbirds.log_cage_fail", new Object[0]).func_211708_a(TextFormatting.RED));
                }
            });
        }
    }

    private static boolean canBirdBeStoredInCapabilites(IBirdStorage cap, PlayerEntity playerIn, EntityAbstractBird target) {
        boolean isNewEntry = false;
        if (!cap.getVariants(target.func_200600_R()).contains(target.getVariant())) {
            cap.add(target.func_200600_R(), target.getVariant());
            if (playerIn instanceof ServerPlayerEntity) {
                ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerIn), (Object)new PacketSyncCapabilities(cap.getAll()));
            }
            isNewEntry = true;
        }
        return isNewEntry;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent("book.exoticbirds.book_tooltip", new Object[0]).func_211708_a(TextFormatting.AQUA));
    }
}

