/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.tileentity;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;
import net.pavocado.exoticbirds.init.ExoticBirdsPacketHandler;
import net.pavocado.exoticbirds.network.PacketBirdcageSound;

public abstract class BirdcageLogic {
    private BirdSpawnData birdData = null;
    private int movementDelay = -1;
    private int soundDelay = -1;
    private double mobRotation;
    private double prevMobRotation;
    private Entity cachedEntity;

    @Nullable
    public CompoundNBT getEntityData() {
        if (this.birdData != null) {
            return this.birdData.getNbt();
        }
        return null;
    }

    public void setEntityData(CompoundNBT nbtIn) {
        if (this.birdData == null && nbtIn != null) {
            this.birdData = new BirdSpawnData(nbtIn);
        }
    }

    private boolean isActivated() {
        BlockPos blockpos = this.getCagePosition();
        return this.getWorld().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, 16.0);
    }

    public void tick() {
        if (this.birdData != null) {
            if (!this.isActivated()) {
                this.prevMobRotation = this.mobRotation;
            } else {
                World world = this.getWorld();
                if (world.field_72995_K) {
                    this.prevMobRotation = this.mobRotation;
                    --this.movementDelay;
                    if (this.movementDelay < 0) {
                        this.movementDelay = world.field_73012_v.nextInt(50) + 30;
                        double targetPos = (world.field_73012_v.nextInt(10) - world.field_73012_v.nextInt(5)) * 20;
                        this.mobRotation = Math.max(this.mobRotation - 50.0, Math.min(this.mobRotation + 50.0, targetPos));
                    }
                } else {
                    --this.soundDelay;
                    if (this.soundDelay == 0) {
                        ExoticBirdsPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(this.getCagePosition())), (Object)new PacketBirdcageSound(this.getCagePosition()));
                    } else if (this.soundDelay < 0) {
                        this.soundDelay = world.field_73012_v.nextInt(160) + 80;
                    }
                }
            }
        }
    }

    public void read(CompoundNBT nbt) {
        if (nbt.func_150297_b("EntityData", 10)) {
            this.setBirdData(new BirdSpawnData(nbt.func_74775_l("EntityData")));
        }
        if (this.getWorld() != null) {
            this.cachedEntity = null;
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        if (this.birdData != null && compound != null) {
            compound.func_218657_a("EntityData", (INBT)this.birdData.getNbt().func_74737_b());
        }
        return compound;
    }

    public Entity getLoggedEntity() {
        Entity entity = null;
        World world = this.getWorld();
        if (this.birdData != null && !world.field_72995_K) {
            CompoundNBT compoundnbt = this.birdData.getNbt();
            entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, e -> e);
        }
        return entity;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getCachedEntity() {
        if (this.cachedEntity == null && this.birdData != null) {
            this.cachedEntity = EntityType.func_220335_a((CompoundNBT)this.birdData.getNbt(), (World)this.getWorld(), Function.identity());
            if (this.birdData.getNbt().func_186856_d() == 1 && this.birdData.getNbt().func_150297_b("id", 8) && this.cachedEntity instanceof MobEntity) {
                ((MobEntity)this.cachedEntity).func_213386_a((IWorld)this.getWorld(), this.getWorld().func_175649_E(new BlockPos(this.cachedEntity)), SpawnReason.SPAWNER, null, null);
            }
        }
        return this.cachedEntity;
    }

    public Entity spawnEntity(Explosion explosion) {
        Entity entity = this.spawnEntity();
        if (entity != null) {
            Vec3d pos = explosion.getPosition();
            float explosionRange = 10.0f;
            double distance = MathHelper.func_76133_a((double)entity.func_195048_a(pos)) / explosionRange;
            double d10 = 1.0 - distance;
            entity.func_70097_a(explosion.func_199591_b(), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)explosionRange + 1.0)));
        }
        return entity;
    }

    public Entity spawnEntity() {
        World world = this.getWorld();
        if (this.birdData != null && !world.field_72995_K) {
            double d2;
            double d1;
            double d0;
            BlockPos blockpos = this.getCagePosition();
            CompoundNBT compoundnbt = this.birdData.getNbt();
            Entity entity = EntityType.func_220335_a((CompoundNBT)compoundnbt, (World)world, arg_0 -> BirdcageLogic.lambda$spawnEntity$2(d0 = (double)blockpos.func_177958_n() + 0.5, d1 = (double)blockpos.func_177956_o() + 0.2, d2 = (double)blockpos.func_177952_p() + 0.5, arg_0));
            if (entity != null) {
                entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 90.0f, 90.0f);
                if (this.birdData.getNbt().func_186856_d() == 1 && this.birdData.getNbt().func_150297_b("id", 8) && this.cachedEntity instanceof MobEntity) {
                    ((MobEntity)this.cachedEntity).func_213386_a((IWorld)this.getWorld(), this.getWorld().func_175649_E(new BlockPos(this.cachedEntity)), SpawnReason.SPAWNER, null, null);
                }
                world.func_217376_c(entity);
                return entity;
            }
        }
        return null;
    }

    public void setBirdData(BirdSpawnData birdDataIn) {
        this.birdData = birdDataIn;
    }

    public abstract World getWorld();

    public abstract BlockPos getCagePosition();

    @OnlyIn(value=Dist.CLIENT)
    public double getMobRotation() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getPrevMobRotation() {
        return this.prevMobRotation;
    }

    private static /* synthetic */ Entity lambda$spawnEntity$2(double d0, double d1, double d2, Entity e) {
        e.func_70012_b(d0, d1, d2, e.field_70177_z, e.field_70125_A);
        return e;
    }

    public final class BirdSpawnData {
        private final CompoundNBT nbt;

        public BirdSpawnData(CompoundNBT nbtIn) {
            this.nbt = nbtIn;
        }

        public CompoundNBT getNbt() {
            return this.nbt;
        }
    }
}

