/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.pavocado.exoticbirds.block.BlockNest;
import net.pavocado.exoticbirds.config.ExoticBirdsConfig;
import net.pavocado.exoticbirds.container.ContainerNest;
import net.pavocado.exoticbirds.init.ExoticBirdsBlocks;
import net.pavocado.exoticbirds.init.ExoticBirdsItems;
import net.pavocado.exoticbirds.init.ExoticBirdsTileEntities;
import net.pavocado.exoticbirds.item.ItemBirdEgg;

public class TileEntityNest
extends TileEntity
implements INamedContainerProvider {
    public ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            if (!stack.func_190926_b()) {
                Item item = stack.func_77973_b();
                return ExoticBirdsConfig.allowAnythingInNests || item == ExoticBirdsItems.MYSTERY_EGG.get() || item == Items.field_151110_aK || item == ExoticBirdsItems.EGGSHELL.get() || item instanceof ItemBirdEgg;
            }
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityNest.this.func_70296_d();
            TileEntityNest.this.updateEggs();
        }
    };
    private final LazyOptional<IItemHandlerModifiable> inventoryCapabilityExternalDown = LazyOptional.of(() -> new RangedWrapper((IItemHandlerModifiable)this.inventory, 0, 3));

    public TileEntityNest() {
        super((TileEntityType)ExoticBirdsTileEntities.NEST.get());
    }

    public void updateEggs() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState blockState = this.field_145850_b.func_180495_p(this.func_174877_v());
            if (!(blockState.func_177230_c() instanceof BlockNest)) {
                return;
            }
            int eggCount = 0;
            for (int j = 0; j < this.inventory.getSlots(); ++j) {
                ItemStack itemstack = this.inventory.getStackInSlot(j);
                if (itemstack.func_190926_b()) continue;
                ++eggCount;
            }
            BlockState newState = (BlockState)this.func_195044_w().func_206870_a((IProperty)BlockNest.EGGS, (Comparable)Integer.valueOf(eggCount));
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 2);
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("inventory", (INBT)this.inventory.serializeNBT());
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(((BlockNest)ExoticBirdsBlocks.NEST.get()).func_149739_a(), new Object[0]);
    }

    @Nonnull
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new ContainerNest(windowId, inventory, this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            switch (side) {
                case DOWN: {
                    return this.inventoryCapabilityExternalDown.cast();
                }
            }
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.inventoryCapabilityExternalDown.invalidate();
    }
}

