/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class ConcreteGolem
extends GolemMultiTextured {
    public static final String ALLOW_RESIST = "Allow Special: Resistance";
    public static final String[] TEXTURE_NAMES = new String[]{"black_concrete", "orange_concrete", "magenta_concrete", "light_blue_concrete", "yellow_concrete", "lime_concrete", "pink_concrete", "gray_concrete", "light_gray_concrete", "cyan_concrete", "purple_concrete", "blue_concrete", "brown_concrete", "green_concrete", "red_concrete", "white_concrete"};
    public static final String[] LOOT_TABLE_NAMES = new String[]{"black", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "white"};

    public ConcreteGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "minecraft", TEXTURE_NAMES, "golems", LOOT_TABLE_NAMES);
        this.func_184644_a(PathNodeType.WATER, -0.8f);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (this.getConfigBool(ALLOW_RESIST) && !source.func_151517_h()) {
            amount *= 0.6f;
            if (source.func_76347_k()) {
                amount *= 0.85f;
            }
        }
        super.func_70665_d(source, amount);
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return GolemTextureBytes.CONCRETE;
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(GolemTextureBytes.CONCRETE, (byte)this.getTextureNum()));
    }
}

