/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.BoneMealItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class StrawGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Crop Boost";
    public static final String SPECIAL_FREQ = "Crop Boost Frequency";

    public StrawGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        if (this.getConfigBool(ALLOW_SPECIAL)) {
            this.field_70714_bg.func_75776_a(3, (Goal)new BoostCropGoal(this, 4, this.getConfigInt(SPECIAL_FREQ)));
        }
    }

    public static class BoostCropGoal
    extends Goal {
        protected final GolemBase golem;
        protected final int range;
        protected final int frequency;

        public BoostCropGoal(GolemBase golemIn, int rangeIn, int freq) {
            this.golem = golemIn;
            this.range = rangeIn;
            this.frequency = freq + this.golem.func_130014_f_().func_201674_k().nextInt(Math.max(10, freq / 2));
        }

        public boolean func_75250_a() {
            return this.golem.func_130014_f_().func_201674_k().nextInt(this.frequency) == 0;
        }

        public void func_75249_e() {
            this.tryBoostCrop();
        }

        private boolean tryBoostCrop() {
            Random rand = this.golem.func_130014_f_().func_201674_k();
            int maxAttempts = 25;
            int variationY = 2;
            int attempts = 0;
            while (attempts++ <= 25) {
                int x1 = rand.nextInt(this.range * 2) - this.range;
                int y1 = rand.nextInt(4) - 2;
                int z1 = rand.nextInt(this.range * 2) - this.range;
                BlockPos blockpos = this.golem.getBlockBelow().func_177982_a(x1, y1, z1);
                BlockState state = this.golem.func_130014_f_().func_180495_p(blockpos);
                if (!(state.func_177230_c() instanceof IGrowable)) continue;
                IGrowable crop = (IGrowable)state.func_177230_c();
                if (!(this.golem.func_130014_f_() instanceof ServerWorld) || !crop.func_176473_a((IBlockReader)this.golem.func_130014_f_(), blockpos, state, this.golem.func_130014_f_().field_72995_K)) continue;
                crop.func_225535_a_((ServerWorld)this.golem.func_130014_f_(), rand, blockpos, state);
                if (this.golem.func_130014_f_().func_201670_d()) {
                    BoneMealItem.func_195965_a((IWorld)this.golem.func_130014_f_(), (BlockPos)blockpos, (int)0);
                }
                attempts = 25;
            }
            return false;
        }
    }
}

