/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.ai;

import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class GoToWaterGoal
extends Goal {
    private final GolemBase golem;
    private final int detectWaterRadius;
    private double targetX;
    private double targetY;
    private double targetZ;
    private final double speed;
    private final World world;

    public GoToWaterGoal(GolemBase golemBase, int radius, double speed) {
        this.golem = golemBase;
        this.detectWaterRadius = radius;
        this.speed = speed;
        this.world = golemBase.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (this.golem.func_70090_H()) {
            return false;
        }
        Vector3d target = this.getNearbyWater();
        if (target == null || !this.golem.shouldMoveToWater(target)) {
            return false;
        }
        this.targetX = target.field_72450_a;
        this.targetY = target.field_72448_b;
        this.targetZ = target.field_72449_c;
        return true;
    }

    public boolean func_75253_b() {
        return !this.golem.func_70661_as().func_75500_f();
    }

    public void func_75249_e() {
        this.golem.func_70661_as().func_75492_a(this.targetX, this.targetY, this.targetZ, this.speed);
    }

    private Vector3d getNearbyWater() {
        Random rand = this.golem.func_70681_au();
        BlockPos pos1 = this.golem.getBlockBelow();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos2 = pos1.func_177982_a(rand.nextInt(this.detectWaterRadius * 2) - this.detectWaterRadius, 2 - rand.nextInt(8), rand.nextInt(this.detectWaterRadius * 2) - this.detectWaterRadius);
            if (this.world.func_180495_p(pos2).func_177230_c() != Blocks.field_150355_j) continue;
            return new Vector3d((double)pos2.func_177958_n(), (double)pos2.func_177956_o(), (double)pos2.func_177952_p());
        }
        return null;
    }
}

