/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.base;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.GolemRenderSettings;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class DefinedTextureGolem
extends GolemBase {
    protected static final DataParameter<String> DATA_TEXTURE = EntityDataManager.func_187226_a(DefinedTextureGolem.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Integer> DATA_VINES = EntityDataManager.func_187226_a(DefinedTextureGolem.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final String KEY_TEXTURE = "Texture";
    protected static final String KEY_VINES = "Vines";
    protected ResourceLocation texture = GolemRenderSettings.FALLBACK_BLOCK;
    protected ResourceLocation vines = null;
    protected int vinesColor = 0;

    public DefinedTextureGolem(EntityType<? extends GolemBase> type, World world) {
        super(type, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)GolemRenderSettings.FALLBACK_BLOCK.toString());
        this.func_184212_Q().func_187214_a(DATA_VINES, (Object)0);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (DATA_TEXTURE.equals(key)) {
            String textureString = this.getTextureString();
            if (!textureString.isEmpty()) {
                this.texture = new ResourceLocation(textureString);
            }
        } else if (DATA_VINES.equals(key)) {
            this.vinesColor = this.getVinesColorData();
            this.vines = this.vinesColor > 0 ? GolemRenderSettings.FALLBACK_VINES : null;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a(KEY_TEXTURE, this.getTextureString());
        nbt.func_74768_a(KEY_VINES, this.getVinesColorData());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setTexture(nbt.func_74779_i(KEY_TEXTURE));
        this.setVinesColorData(nbt.func_74762_e(KEY_VINES));
    }

    public void setTexture(String tex) {
        if (!tex.isEmpty()) {
            this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)tex);
            this.texture = new ResourceLocation(tex);
        }
    }

    public String getTextureString() {
        return (String)this.func_184212_Q().func_187225_a(DATA_TEXTURE);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setVinesColorData(int vinesColorData) {
        this.func_184212_Q().func_187227_b(DATA_VINES, (Object)vinesColorData);
        this.vinesColor = vinesColorData;
        this.vines = vinesColorData > 0 ? GolemRenderSettings.FALLBACK_VINES : null;
    }

    public int getVinesColorData() {
        return (Integer)this.func_184212_Q().func_187225_a(DATA_VINES);
    }

    public int getVinesColor() {
        return this.vinesColor;
    }

    @Nullable
    public ResourceLocation getVines() {
        return this.vines;
    }
}

