/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.entity.DispenserGolem;
import com.mcmoddev.golems.entity.FurnaceGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showSpecialChild = false;
    protected boolean showAttack = true;

    public List<IFormattableTextComponent> getEntityDescription(GolemBase golem) {
        LinkedList<IFormattableTextComponent> list = new LinkedList<IFormattableTextComponent>();
        if (this.showAttack) {
            double attack = golem.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            list.add(new TranslationTextComponent("entitytip.attack").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(Double.toString(attack)).func_240699_a_(TextFormatting.WHITE)));
        }
        if (this.showSpecial) {
            if (golem instanceof FurnaceGolem) {
                this.addFurnaceGolemInfo((FurnaceGolem)golem, list);
            }
            if (golem instanceof DispenserGolem) {
                this.addDispenserGolemInfo((DispenserGolem)golem, list);
            }
        }
        if (!golem.func_70631_g_() && this.showSpecial || golem.func_70631_g_() && this.showSpecialChild) {
            golem.getGolemContainer().addDescription(list);
        }
        return list;
    }

    protected void addFurnaceGolemInfo(FurnaceGolem g, List<IFormattableTextComponent> list) {
        int fuel = g.getFuel();
        int percentFuel = (int)Math.ceil(g.getFuelPercentage() * 100.0f);
        TextFormatting color = percentFuel < 6 ? TextFormatting.RED : (percentFuel < 16 ? TextFormatting.YELLOW : TextFormatting.WHITE);
        String fuelString = GolemDescriptionManager.isShiftDown() ? Integer.toString(fuel) : Integer.toString(percentFuel) + "%";
        list.add(new TranslationTextComponent("entitytip.fuel").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(fuelString).func_240699_a_(color)));
    }

    protected void addDispenserGolemInfo(DispenserGolem g, List<IFormattableTextComponent> list) {
        int arrows = g.getArrowsInInventory();
        if (arrows > 0 && GolemDescriptionManager.isShiftDown()) {
            TextFormatting color = TextFormatting.WHITE;
            String arrowString = Integer.toString(arrows);
            list.add(new TranslationTextComponent("entitytip.arrows").func_240699_a_(TextFormatting.GRAY).func_230529_a_((ITextComponent)new StringTextComponent(": ")).func_230529_a_((ITextComponent)new StringTextComponent(arrowString).func_240699_a_(color)));
        }
    }

    protected static boolean isShiftDown() {
        return Screen.func_231173_s_();
    }
}

