/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.main;

import com.mcmoddev.golems.blocks.BlockGolemHead;
import com.mcmoddev.golems.blocks.BlockUtilityGlow;
import com.mcmoddev.golems.blocks.BlockUtilityPower;
import com.mcmoddev.golems.events.GolemRegistrarEvent;
import com.mcmoddev.golems.events.handlers.GolemCommonEventHandler;
import com.mcmoddev.golems.integration.AddonLoader;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import com.mcmoddev.golems.items.ItemGolemSpell;
import com.mcmoddev.golems.items.ItemInfoBook;
import com.mcmoddev.golems.main.ExtraGolemsEntities;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.proxies.ProxyClient;
import com.mcmoddev.golems.proxies.ProxyCommon;
import com.mcmoddev.golems.proxies.ProxyServer;
import com.mcmoddev.golems.util.GolemRegistrar;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="golems")
@Mod.EventBusSubscriber(modid="golems", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExtraGolems {
    public static final String MODID = "golems";
    public static final ProxyCommon PROXY = (ProxyCommon)DistExecutor.runForDist(() -> () -> new ProxyClient(), () -> () -> new ProxyServer());
    public static final Logger LOGGER = LogManager.getFormatterLogger((String)"golems");

    public ExtraGolems() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        MinecraftForge.EVENT_BUS.register((Object)new GolemCommonEventHandler());
        PROXY.registerListeners();
        ExtraGolemsEntities.initEntityTypes();
        AddonLoader.initEntityTypes();
        MinecraftForge.EVENT_BUS.post((Event)new GolemRegistrarEvent());
        ExtraGolemsConfig.setupConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ExtraGolemsConfig.COMMON_CONFIG);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        AddonLoader.interModEnqueueEvent(event);
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        LOGGER.info("registerEntities");
        GolemRegistrar.getContainers().forEach(container -> event.getRegistry().register(container.getEntityType()));
        PROXY.registerEntityRenders();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        LOGGER.info("registerItems");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(GolemItems.GOLEM_HEAD, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)){

            @OnlyIn(value=Dist.CLIENT)
            public boolean func_77636_d(ItemStack stack) {
                return true;
            }
        }.setRegistryName(GolemItems.GOLEM_HEAD.getRegistryName()), (Item)new ItemBedrockGolem().setRegistryName(MODID, "spawn_bedrock_golem"), (Item)new ItemGolemSpell().setRegistryName(MODID, "golem_paper"), (Item)new ItemInfoBook().setRegistryName(MODID, "info_book")});
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        LOGGER.info("registerBlocks");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new BlockGolemHead().setRegistryName(MODID, "golem_head"), (Block)new BlockUtilityGlow(Material.field_151592_s, 1.0f).setRegistryName(MODID, "light_provider"), (Block)new BlockUtilityPower(15).setRegistryName(MODID, "power_provider")});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        LOGGER.info("registerContainers");
        event.getRegistry().register(GolemItems.CRAFTING_GOLEM.setRegistryName(MODID, "crafting_portable"));
        event.getRegistry().register(GolemItems.DISPENSER_GOLEM.setRegistryName(MODID, "dispenser_portable"));
        PROXY.registerContainerRenders();
    }
}

