/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.mcmoddev.golems.renders.DynamicTextureState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;

public class GolemRenderType
extends RenderType {
    private static final Map<ResourceLocation, DynamicTextureState> dynamicTextureMap = new HashMap<ResourceLocation, DynamicTextureState>();
    public static final ResourceLocation TEMPLATE = new ResourceLocation("golems", "textures/entity/layer/template.png");
    public static final ResourceLocation MUSHROOM_TEMPLATE = new ResourceLocation("golems", "textures/entity/golem_mushroom/template.png");
    public static final ResourceLocation WOOL_TEMPLATE = new ResourceLocation("golems", "textures/entity/golem_wool/template.png");

    public GolemRenderType(String name, VertexFormat vertexFormat, int glQuads, int i2, boolean b1, boolean b2, Runnable r1, Runnable r2) {
        super(name, vertexFormat, glQuads, i2, b1, b2, r1, r2);
    }

    public static void reloadDynamicTextureMap() {
        HashMap<ResourceLocation, DynamicTextureState> copy = new HashMap<ResourceLocation, DynamicTextureState>(dynamicTextureMap);
        copy.entrySet().forEach(e -> dynamicTextureMap.put((ResourceLocation)e.getKey(), new DynamicTextureState((ResourceLocation)e.getKey(), ((DynamicTextureState)e.getValue()).templateImage)));
    }

    private static RenderState.TextureState getTextureState(ResourceLocation texture, ResourceLocation template) {
        if (!dynamicTextureMap.containsKey(texture)) {
            dynamicTextureMap.put(texture, new DynamicTextureState(texture, template));
        }
        return GolemRenderType.dynamicTextureMap.get((Object)texture).state;
    }

    public static RenderType getGolemCutout(ResourceLocation texture, boolean dynamic) {
        return GolemRenderType.getGolemCutout(texture, TEMPLATE, dynamic);
    }

    public static RenderType getGolemCutout(ResourceLocation texture, ResourceLocation template, boolean dynamic) {
        if (!dynamic) {
            return RenderType.func_228640_c_((ResourceLocation)texture);
        }
        return GolemRenderType.func_228633_a_((String)"golem_cutout", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(field_228510_b_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228724_a_(GolemRenderType.getTextureState(texture, template)).func_228728_a_(true));
    }

    public static RenderType getGolemTransparent(ResourceLocation texture, boolean dynamic) {
        if (!dynamic) {
            return RenderType.func_228644_e_((ResourceLocation)texture);
        }
        return GolemRenderType.func_228633_a_((String)"golem_transparent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(GolemRenderType.getTextureState(texture, TEMPLATE)).func_228726_a_(field_228515_g_).func_228716_a_(field_228532_x_).func_228713_a_(field_228517_i_).func_228714_a_(field_228491_A_).func_228719_a_(field_228528_t_).func_228722_a_(field_228530_v_).func_228728_a_(true));
    }

    public static RenderType getGolemOutline(ResourceLocation texture, boolean dynamic) {
        if (!dynamic) {
            return RenderType.func_228654_j_((ResourceLocation)texture);
        }
        return GolemRenderType.func_228632_a_((String)"golem_outline", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(GolemRenderType.getTextureState(texture, TEMPLATE)).func_228714_a_(RenderState.CullState.field_228491_A_).func_228715_a_(field_228492_B_).func_228713_a_(field_228517_i_).func_228725_a_(field_228525_q_).func_228717_a_(field_228501_K_).func_228721_a_(field_228505_O_).func_230173_a_(RenderType.OutlineState.IS_OUTLINE));
    }
}

