/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.renders.GolemRenderType;
import com.mcmoddev.golems.renders.model.GolemFlowerLayer;
import com.mcmoddev.golems.renders.model.GolemKittyLayer;
import com.mcmoddev.golems.renders.model.GolemModel;
import com.mcmoddev.golems.renders.model.SimpleTextureLayer;
import com.mcmoddev.golems.util.GolemRenderSettings;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.TextFormatting;

public class GolemRenderer<T extends GolemBase>
extends MobRenderer<T, GolemModel<T>> {
    protected static final ResourceLocation boneTexture = new ResourceLocation("golems", "textures/entity/golem_bone_skeleton.png");
    protected static final ResourceLocation specialTexture = new ResourceLocation("golems", "textures/entity/special.png");
    protected static final ResourceLocation specialTexture2 = new ResourceLocation("golems", "textures/entity/special2.png");
    private static final Map<IronGolemEntity.Cracks, ResourceLocation> cracksToTextureMap = ImmutableMap.of((Object)IronGolemEntity.Cracks.LOW, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_low.png"), (Object)IronGolemEntity.Cracks.MEDIUM, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_medium.png"), (Object)IronGolemEntity.Cracks.HIGH, (Object)new ResourceLocation("textures/entity/iron_golem/iron_golem_crackiness_high.png"));
    protected boolean hideVines;
    protected boolean hideEyes;
    protected boolean isAlphaLayer;

    public GolemRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new GolemModel(), 0.5f);
    }

    public GolemRenderer<T> withLayer(LayerRenderer<T, GolemModel<T>> layer) {
        this.func_177094_a(layer);
        return this;
    }

    public GolemRenderer<T> withAllLayers() {
        this.func_177094_a(new SimpleTextureLayer(this, g -> this.hideEyes ? null : g.getGolemContainer().getRenderSettings().getEyesTexture().getTexture(g), g -> 0xFFFFFF, g -> g.getGolemContainer().getRenderSettings().getEyesLighting().disableLighting(g), 1.0f));
        this.func_177094_a(new SimpleTextureLayer(this, g -> {
            GolemRenderSettings settings = g.getGolemContainer().getRenderSettings();
            return settings.hasVines() && !this.hideVines ? settings.getVinesTexture().getTexture(g) : null;
        }, g -> g.getGolemContainer().getRenderSettings().getVinesColorProvider().getColor(g), g -> g.getGolemContainer().getRenderSettings().getVinesLighting().disableLighting(g), 1.0f));
        this.func_177094_a(new SimpleTextureLayer(this, g -> cracksToTextureMap.get(g.func_226512_l_()), g -> 0xFFFFFF, g -> false, 0.55f));
        this.func_177094_a(new GolemFlowerLayer(this));
        this.func_177094_a(new GolemKittyLayer(this));
        return this;
    }

    public void render(T golem, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (golem.func_82150_aj()) {
            return;
        }
        GolemRenderSettings settings = ((GolemBase)((Object)golem)).getGolemContainer().getRenderSettings();
        matrixStackIn.func_227860_a_();
        if (((GolemBase)((Object)golem)).func_70631_g_()) {
            float scaleChild = 0.5f;
            matrixStackIn.func_227862_a_(scaleChild, scaleChild, scaleChild);
        }
        if (settings.hasColor()) {
            Vector3f colors = GolemRenderSettings.unpackColor(settings.getBlockColorProvider().getColor((GolemBase)((Object)golem)));
            ((GolemModel)this.func_217764_d()).setColor(colors.func_195899_a(), colors.func_195900_b(), colors.func_195902_c());
        } else {
            ((GolemModel)this.field_77045_g).resetColor();
        }
        this.isAlphaLayer = settings.hasTransparency();
        if (this.isAlphaLayer) {
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
        }
        int packedLight = settings.getTextureLighting().disableLighting((GolemBase)((Object)golem)) ? 0xF000F0 : packedLightIn;
        super.func_225623_a_(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLight);
        if (this.isAlphaLayer) {
            RenderSystem.disableBlend();
        }
        matrixStackIn.func_227865_b_();
    }

    public ResourceLocation getEntityTexture(T golem) {
        GolemRenderSettings settings = ((GolemBase)((Object)golem)).getGolemContainer().getRenderSettings();
        this.hideVines = false;
        this.hideEyes = false;
        ResourceLocation texture = settings.hasPrefabTexture() ? settings.getPrefabTexture().getTexture((GolemBase)((Object)golem)) : settings.getBlockTexture().getTexture((GolemBase)((Object)golem));
        if (ExtraGolemsConfig.halloween() && GolemRenderer.isNightTime(golem)) {
            texture = boneTexture;
            this.hideVines = true;
        } else if (golem.func_145818_k_()) {
            String s = TextFormatting.func_110646_a((String)golem.func_200200_C_().getString());
            if ("Ganondorf".equals(s)) {
                texture = specialTexture;
                this.hideVines = true;
                this.hideEyes = true;
            }
            if ("Cookie".equals(s)) {
                texture = specialTexture2;
                this.hideVines = true;
                this.hideEyes = true;
            }
        }
        return texture;
    }

    @Nullable
    protected RenderType func_230496_a_(T golem, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        GolemRenderSettings settings = ((GolemBase)((Object)golem)).getGolemContainer().getRenderSettings();
        ResourceLocation texture = this.getEntityTexture(golem);
        boolean dynamic = this.isDynamic(texture, settings);
        if (isVisible || isVisibleToPlayer || this.isAlphaLayer) {
            return GolemRenderType.getGolemTransparent(texture, dynamic);
        }
        if (golem.func_225510_bt_()) {
            return GolemRenderType.getGolemOutline(texture, dynamic);
        }
        return GolemRenderType.getGolemCutout(texture, dynamic);
    }

    protected boolean isDynamic(ResourceLocation texture, GolemRenderSettings settings) {
        return texture != boneTexture && texture != specialTexture && texture != specialTexture2 && !settings.hasPrefabTexture();
    }

    public static boolean isNightTime(GolemBase golem) {
        long time = golem.field_70170_p.func_72820_D() % 24000L;
        return time > 13000L && time < 23000L;
    }
}

