/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders.model;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.renders.model.GolemModel;
import com.mcmoddev.golems.util.GolemRenderSettings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class SimpleTextureLayer<T extends GolemBase>
extends LayerRenderer<T, GolemModel<T>> {
    final GolemRenderSettings.ITextureProvider textureProvider;
    final GolemRenderSettings.IColorProvider colorProvider;
    final GolemRenderSettings.ILightingProvider lightingProvider;
    final float alphaColor;

    public SimpleTextureLayer(IEntityRenderer<T, GolemModel<T>> ientityrenderer, GolemRenderSettings.ITextureProvider texture, GolemRenderSettings.IColorProvider color, GolemRenderSettings.ILightingProvider lighting, float alpha) {
        super(ientityrenderer);
        this.textureProvider = texture;
        this.colorProvider = color;
        this.lightingProvider = lighting;
        this.alphaColor = alpha;
    }

    public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T golem, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation texture = this.textureProvider.getTexture((GolemBase)((Object)golem));
        if (!golem.func_82150_aj() && texture != null) {
            matrixStackIn.func_227860_a_();
            Vector3f colors = GolemRenderSettings.unpackColor(this.colorProvider.getColor((GolemBase)((Object)golem)));
            int packedLight = this.lightingProvider.disableLighting((GolemBase)((Object)golem)) ? 0xF000F0 : packedLightIn;
            IVertexBuilder vertexBuilder = bufferIn.getBuffer(this.getRenderType(texture));
            if (this.alphaColor < 1.0f) {
                RenderSystem.defaultAlphaFunc();
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alphaColor);
            }
            ((GolemModel)this.func_215332_c()).setColor(colors.func_195899_a(), colors.func_195900_b(), colors.func_195902_c());
            ((GolemModel)this.func_215332_c()).func_225598_a_(matrixStackIn, vertexBuilder, packedLight, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, this.alphaColor);
            if (this.alphaColor < 1.0f) {
                RenderSystem.disableBlend();
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected RenderType getRenderType(ResourceLocation texture) {
        return this.alphaColor < 1.0f ? RenderType.func_228644_e_((ResourceLocation)texture) : RenderType.func_228640_c_((ResourceLocation)texture);
    }
}

