/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class GolemRenderSettings {
    public static final ResourceLocation FALLBACK_BLOCK = new ResourceLocation("minecraft", "textures/block/clay.png");
    public static final ResourceLocation FALLBACK_PREFAB = new ResourceLocation("minecraft", "textures/entity/iron_golem/iron_golem.png");
    public static final ResourceLocation FALLBACK_VINES = new ResourceLocation("golems", "textures/entity/layer/vines.png");
    public static final ResourceLocation FALLBACK_EYES = new ResourceLocation("golems", "textures/entity/layer/eyes/eyes.png");
    public static final int VINES_COLOR = 8626266;
    private final boolean hasCustomRender;
    private final boolean hasTransparency;
    private final ILightingProvider textureGlow;
    private final ITextureProvider blockTexture;
    private final boolean hasVines;
    private final ILightingProvider vinesGlow;
    private final ITextureProvider vinesTexture;
    private final ILightingProvider eyesGlow;
    private final ITextureProvider eyesTexture;
    private final boolean hasPrefabTexture;
    private final ITextureProvider prefabTexture;
    private final boolean hasColor;
    private final IColorProvider textureColorProvider;
    private final IColorProvider vinesColorProvider;

    public GolemRenderSettings(boolean lHasCustomRender, boolean lHasTransparency, ILightingProvider lTextureGlow, ITextureProvider lBlockTextureProvider, boolean lHasVines, boolean lVinesGlow, ITextureProvider lVinesTextureProvider, boolean lEyesGlow, ITextureProvider lEyesTextureProvider, boolean lHasPrefabTexture, ITextureProvider lPrefabTextureProvider, boolean lHasColor, IColorProvider lTextureColorProvider, IColorProvider lVinesColorProvider) {
        this.hasCustomRender = lHasCustomRender;
        this.hasTransparency = lHasTransparency;
        this.textureGlow = lTextureGlow;
        this.blockTexture = lBlockTextureProvider;
        this.hasVines = lHasVines;
        this.vinesGlow = g -> lVinesGlow;
        this.vinesTexture = lVinesTextureProvider;
        this.eyesGlow = g -> lEyesGlow;
        this.eyesTexture = lEyesTextureProvider;
        this.hasPrefabTexture = lHasPrefabTexture;
        this.prefabTexture = lPrefabTextureProvider;
        this.hasColor = lHasColor;
        this.textureColorProvider = lTextureColorProvider;
        this.vinesColorProvider = lVinesColorProvider;
    }

    public boolean hasCustomRender() {
        return this.hasCustomRender;
    }

    public boolean hasTransparency() {
        return this.hasTransparency;
    }

    public ILightingProvider getTextureLighting() {
        return this.textureGlow;
    }

    public ITextureProvider getBlockTexture() {
        return this.blockTexture;
    }

    public boolean hasVines() {
        return this.hasVines;
    }

    public ILightingProvider getVinesLighting() {
        return this.vinesGlow;
    }

    public ITextureProvider getVinesTexture() {
        return this.vinesTexture;
    }

    public ILightingProvider getEyesLighting() {
        return this.eyesGlow;
    }

    public ITextureProvider getEyesTexture() {
        return this.eyesTexture;
    }

    public boolean hasPrefabTexture() {
        return this.hasPrefabTexture;
    }

    public ITextureProvider getPrefabTexture() {
        return this.prefabTexture;
    }

    public boolean hasColor() {
        return this.hasColor;
    }

    public IColorProvider getBlockColorProvider() {
        return this.textureColorProvider;
    }

    public IColorProvider getVinesColorProvider() {
        return this.vinesColorProvider;
    }

    public static Vector3f unpackColor(int color) {
        long tmpColor = color;
        if ((tmpColor & 0xFFFFFFFFFC000000L) == 0L) {
            tmpColor |= 0xFFFFFFFFFF000000L;
        }
        float colorRed = (float)(tmpColor >> 16 & 0xFFL) / 255.0f;
        float colorGreen = (float)(tmpColor >> 8 & 0xFFL) / 255.0f;
        float colorBlue = (float)(tmpColor & 0xFFL) / 255.0f;
        return new Vector3f(colorRed, colorGreen, colorBlue);
    }

    @FunctionalInterface
    public static interface ILightingProvider {
        public boolean disableLighting(GolemBase var1);
    }

    @FunctionalInterface
    public static interface IColorProvider {
        public int getColor(GolemBase var1);
    }

    @FunctionalInterface
    public static interface ITextureProvider {
        public ResourceLocation getTexture(GolemBase var1);
    }
}

