/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_quark.entity;

import com.mcmoddev.golems.blocks.BlockUtilityGlow;
import com.mcmoddev.golems.entity.ai.PlaceUtilityBlockGoal;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.util.GolemRenderSettings;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.world.module.underground.CaveCrystalUndergroundBiomeModule;

public final class CaveCrystalGolem
extends GolemMultiTextured {
    public static final String ALLOW_SPECIAL = "Allow Special: Emit Light";
    private static final String[] TEXTURE_NAMES = new String[]{"red_crystal", "orange_crystal", "yellow_crystal", "green_crystal", "blue_crystal", "indigo_crystal", "violet_crystal", "white_crystal", "black_crystal"};
    private static final String[] LOOT_TABLE_NAMES = new String[]{"red", "orange", "yellow", "green", "blue", "indigo", "violet", "white", "black"};
    private static final int[] CRYSTAL_COLORS = new int[]{0xFF0000, 0xFF8000, 0xFFFF00, 65280, 65535, 255, 0xFF00FF, 0xFFFFFF, 0};
    private static final Map<Block, Byte> textureBytes = new HashMap<Block, Byte>();

    public CaveCrystalGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "quark", TEXTURE_NAMES, "golems_quark", LOOT_TABLE_NAMES);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        int lightInt = 11;
        BlockState state = (BlockState)GolemItems.UTILITY_LIGHT.func_176223_P().func_206870_a((Property)BlockUtilityGlow.LIGHT_LEVEL, (Comparable)Integer.valueOf(lightInt));
        this.field_70714_bg.func_75776_a(9, (Goal)new PlaceUtilityBlockGoal(this, state, 6, this.getConfigBool(ALLOW_SPECIAL), true, null));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d() && this.field_70146_Z.nextInt(3) == 0) {
            Vector3d pos = this.func_213303_ch();
            double px = pos.field_72450_a + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf();
            double py = pos.field_72448_b + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg() - 0.25;
            double pz = pos.field_72449_c + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf();
            Vector3f colors = GolemRenderSettings.unpackColor(CRYSTAL_COLORS[this.getTextureNum()]);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197608_a, px, py, pz, (double)colors.func_195899_a(), (double)colors.func_195900_b(), (double)colors.func_195902_c());
        }
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(textureBytes, (byte)this.getTextureNum()));
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        if (textureBytes.isEmpty()) {
            CaveCrystalGolem.fillTextureBytes();
        }
        return textureBytes;
    }

    private static void fillTextureBytes() {
        if (ModuleLoader.INSTANCE.isModuleEnabled(CaveCrystalUndergroundBiomeModule.class)) {
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "red_crystal")), (byte)0);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "orange_crystal")), (byte)1);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "yellow_crystal")), (byte)2);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "green_crystal")), (byte)3);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "blue_crystal")), (byte)4);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "indigo_crystal")), (byte)5);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "violet_crystal")), (byte)6);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "white_crystal")), (byte)7);
            textureBytes.put((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "black_crystal")), (byte)8);
        }
    }
}

