/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import tschipp.fakename.CommandFakeName;
import tschipp.fakename.FakeName;
import tschipp.fakename.FakeNamePacket;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FakenameEvents {
    @SubscribeEvent
    public static void serverLoad(FMLServerStartingEvent event) {
        CommandFakeName.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent
    public static void renderName(PlayerEvent.NameFormat event) {
        CompoundNBT tag = event.getPlayer().getPersistentData();
        if (tag.func_74764_b("fakename")) {
            event.setDisplayname(tag.func_74779_i("fakename"));
        } else {
            event.setDisplayname(event.getUsername());
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            if (player.getPersistentData().func_74764_b("fakename")) {
                FakeName.sendPacket(player, player.getPersistentData().func_74779_i("fakename"), 0);
            }
            for (PlayerEntity other : player.func_184102_h().func_184103_al().func_181057_v()) {
                if (!other.getPersistentData().func_74764_b("fakename")) continue;
                FakeName.network.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new FakeNamePacket(other.getPersistentData().func_74779_i("fakename"), other.func_145782_y(), 0));
            }
        }
    }

    @SubscribeEvent
    public static void onTracking(PlayerEvent.StartTracking event) {
        PlayerEntity targetPlayer;
        if (event.getTarget() instanceof PlayerEntity && (targetPlayer = (PlayerEntity)event.getTarget()).getPersistentData() != null && targetPlayer.getPersistentData().func_74764_b("fakename")) {
            ServerPlayerEntity toRecieve = (ServerPlayerEntity)event.getPlayer();
            FakeName.network.send(PacketDistributor.PLAYER.with(() -> toRecieve), (Object)new FakeNamePacket(targetPlayer.getPersistentData().func_74779_i("fakename"), targetPlayer.func_145782_y(), 0));
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        PlayerEntity oldPlayer = event.getOriginal();
        PlayerEntity newPlayer = event.getPlayer();
        if (oldPlayer.getPersistentData().func_74764_b("fakename")) {
            String fakename = oldPlayer.getPersistentData().func_74779_i("fakename");
            newPlayer.getPersistentData().func_74778_a("fakename", fakename);
        }
    }
}

