/*
 * Decompiled with CFR 0.152.
 */
package tschipp.fakename;

import java.util.Iterator;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import tschipp.fakename.CommandFakeName;
import tschipp.fakename.CommandRealName;
import tschipp.fakename.CommonProxy;
import tschipp.fakename.FakeNamePacket;
import tschipp.fakename.FakeNamePacketHandler;

@Mod(modid="fakename", name="Fake Name", version="1.2", acceptedMinecraftVersions="[1.10.2]")
public class FakeName {
    @Mod.Instance(value="fakename")
    public static FakeName instance;
    public static SimpleNetworkWrapper network;
    public static final String CLIENT_PROXY = "tschipp.fakename.ClientProxy";
    public static final String COMMON_PROXY = "tschipp.fakename.CommonProxy";
    @SidedProxy(clientSide="tschipp.fakename.ClientProxy", serverSide="tschipp.fakename.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit(event);
        network = NetworkRegistry.INSTANCE.newSimpleChannel("FakeNameChannel");
        network.registerMessage(FakeNamePacketHandler.class, FakeNamePacket.class, 0, Side.CLIENT);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandFakeName());
        event.registerServerCommand((ICommand)new CommandRealName());
    }

    @SubscribeEvent
    public void renderName(PlayerEvent.NameFormat event) {
        NBTTagCompound tag = event.getEntityPlayer().getEntityData();
        if (tag.func_74764_b("fakename")) {
            event.setDisplayname(tag.func_74779_i("fakename"));
        } else {
            event.setDisplayname(event.getUsername());
        }
    }

    @SubscribeEvent
    public void onJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            WorldServer serverWorld = (WorldServer)event.player.field_70170_p;
            Iterator playersTracking = serverWorld.func_73039_n().getTrackingPlayers((Entity)player).iterator();
            if (player.getEntityData() != null && player.getEntityData().func_74764_b("fakename")) {
                while (playersTracking.hasNext()) {
                    network.sendTo((IMessage)new FakeNamePacket(player.getEntityData().func_74779_i("fakename"), player.func_145782_y(), 0), (EntityPlayerMP)playersTracking.next());
                }
            }
        }
    }

    @SubscribeEvent
    public void onTracking(PlayerEvent.StartTracking event) {
        if (event.getTarget() instanceof EntityPlayer) {
            EntityPlayer targetPlayer = (EntityPlayer)event.getTarget();
            System.out.println("The Targeted Player is " + targetPlayer);
            if (targetPlayer.getEntityData() != null && targetPlayer.getEntityData().func_74764_b("fakename")) {
                EntityPlayerMP toRecieve = (EntityPlayerMP)event.getEntityPlayer();
                System.out.println("The Recieving Player is " + toRecieve);
                network.sendTo((IMessage)new FakeNamePacket(targetPlayer.getEntityData().func_74779_i("fakename"), targetPlayer.func_145782_y(), 0), toRecieve);
            }
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        EntityPlayer oldPlayer = event.getOriginal();
        EntityPlayer newPlayer = event.getEntityPlayer();
        if (oldPlayer.getEntityData().func_74764_b("fakename")) {
            String fakename = oldPlayer.getEntityData().func_74779_i("fakename");
            newPlayer.getEntityData().func_74778_a("fakename", fakename);
        }
    }
}

