/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidFallThroughEvent;
import net.blay09.mods.forgivingvoid.mixin.ServerGamePacketListenerImplAccessor;
import net.blay09.mods.forgivingvoid.mixin.ServerPlayerAccessor;
import net.blay09.mods.forgivingvoid.mixin.ThrownTridentAccessor;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";
    public static final Set<class_2248> FALL_CATCHING_BLOCKS = Set.of(class_2246.field_10343);

    public static void initialize() {
        ForgivingVoidConfig.initialize();
        Balm.getEvents().onEvent(LivingFallEvent.class, ForgivingVoid::onLivingEntityFall);
        Set<class_2960> entityAllowList = ForgivingVoidConfig.getActive().entityAllowList;
        boolean onlyPlayersExplicitlyAllowed = entityAllowList.isEmpty() || entityAllowList.size() == 1 && entityAllowList.contains(new class_2960("player"));
        boolean otherEntitiesImplicitlyAllowed = ForgivingVoidConfig.getActive().tridentForgiveness;
        if (onlyPlayersExplicitlyAllowed && !otherEntitiesImplicitlyAllowed) {
            Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, ForgivingVoid::onPlayerTick);
        } else {
            Balm.getEvents().onTickEvent(TickType.Entity, TickPhase.Start, ForgivingVoid::onEntityTick);
        }
    }

    public static void onPlayerTick(class_3222 player) {
        ForgivingVoid.onEntityTick((class_1297)player);
    }

    /*
     * Unable to fully structure code
     */
    public static void onEntityTick(class_1297 entity) {
        if (!ForgivingVoid.isAllowedEntity(entity)) {
            return;
        }
        triggerAtY = entity.method_37908().method_31607() - ForgivingVoidConfig.getActive().triggerAtDistanceBelow;
        v0 = isInVoid = entity.method_23318() < (double)triggerAtY && entity.field_6036 < (double)triggerAtY;
        if (!(entity instanceof class_3222)) ** GOTO lbl-1000
        player = (class_3222)entity;
        if (((ServerGamePacketListenerImplAccessor)player.field_13987).getAwaitingPositionFromClient() != null) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isTeleporting = v1;
        persistentData = Balm.getHooks().getPersistentData(entity);
        if (isInVoid && !isTeleporting && ForgivingVoid.isEnabledForDimension((class_5321<class_1937>)entity.method_37908().method_27983()) && ForgivingVoid.fireForgivingVoidEvent(entity)) {
            if (entity instanceof class_1309) {
                livingEntity = (class_1309)entity;
                livingEntity.method_6092(new class_1293(class_1294.field_5919, 60, 3));
            }
            if (entity.method_5782()) {
                entity.method_5772();
            }
            entity.method_5848();
            if (entity instanceof ServerPlayerAccessor) {
                player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(true);
            }
            entity.method_5859(entity.method_23317(), (double)ForgivingVoidConfig.getActive().fallingHeight, entity.method_23321());
            persistentData.method_10556("ForgivingVoidIsFalling", true);
        } else if (persistentData.method_10577("ForgivingVoidIsFalling")) {
            if (ForgivingVoid.hasLanded(entity) || ForgivingVoid.isOrMayFly(entity)) {
                persistentData.method_10556("ForgivingVoidIsFalling", false);
                if (entity instanceof ServerPlayerAccessor) {
                    player = (ServerPlayerAccessor)entity;
                    player.setIsChangingDimension(false);
                }
                return;
            }
            if (ForgivingVoidConfig.getActive().disableVanillaAntiCheatWhileFalling && entity instanceof ServerPlayerAccessor) {
                player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(true);
            }
        }
    }

    private static boolean isAllowedEntity(class_1297 entity) {
        class_1685 trident;
        Byte loyalty;
        Set<class_2960> entityAllowList = ForgivingVoidConfig.getActive().entityAllowList;
        class_2960 entityId = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (entityAllowList.isEmpty() && entity instanceof class_1657) {
            return true;
        }
        if (ForgivingVoidConfig.getActive().tridentForgiveness && entity instanceof class_1685 && (loyalty = (Byte)(trident = (class_1685)entity).method_5841().method_12789(ThrownTridentAccessor.getIdLoyalty())) > 0) {
            return true;
        }
        return entityAllowList.contains(entityId);
    }

    private static boolean hasLanded(class_1297 entity) {
        if (entity.method_24828() || entity.method_5799() || entity.method_5771()) {
            return true;
        }
        class_2680 landedOnState = entity.method_37908().method_8320(entity.method_24515());
        return FALL_CATCHING_BLOCKS.contains(landedOnState.method_26204());
    }

    private static boolean isOrMayFly(class_1297 entity) {
        if (!(entity instanceof class_1657)) {
            return false;
        }
        class_1657 player = (class_1657)entity;
        return player.method_31549().field_7479 || player.method_31549().field_7478;
    }

    public static void onLivingEntityFall(LivingFallEvent event) {
        class_2487 persistentData;
        class_1309 entity = event.getEntity();
        if (ForgivingVoid.isAllowedEntity((class_1297)entity) && (persistentData = Balm.getHooks().getPersistentData((class_1297)entity)).method_10577("ForgivingVoidIsFalling")) {
            float damage = ForgivingVoidConfig.getActive().damageOnFall;
            if (ForgivingVoidConfig.getActive().preventDeath && entity.method_6032() - damage <= 0.0f) {
                damage = entity.method_6032() - 1.0f;
            }
            event.setFallDamageOverride(Float.valueOf(damage));
            if (entity instanceof ServerPlayerAccessor) {
                ServerPlayerAccessor player = (ServerPlayerAccessor)entity;
                player.setIsChangingDimension(false);
            }
        }
    }

    private static boolean fireForgivingVoidEvent(class_1297 entity) {
        ForgivingVoidFallThroughEvent event = new ForgivingVoidFallThroughEvent(entity);
        Balm.getEvents().fireEvent((Object)event);
        return !event.isCanceled();
    }

    private static boolean isEnabledForDimension(class_5321<class_1937> dimensionKey) {
        if (dimensionKey == class_1937.field_25179) {
            return ForgivingVoidConfig.getActive().triggerInOverworld;
        }
        if (dimensionKey == class_1937.field_25181) {
            return ForgivingVoidConfig.getActive().triggerInEnd;
        }
        if (dimensionKey == class_1937.field_25180) {
            return ForgivingVoidConfig.getActive().triggerInNether;
        }
        class_2960 dimension = dimensionKey.method_29177();
        Set<class_2960> dimensionAllowList = ForgivingVoidConfig.getActive().dimensionAllowList;
        Set<class_2960> dimensionDenyList = ForgivingVoidConfig.getActive().dimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension)) {
            return false;
        }
        return !dimensionDenyList.contains(dimension);
    }
}

