/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.LivingFallEvent;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidFallThroughEvent;
import net.blay09.mods.forgivingvoid.mixin.ServerGamePacketListenerImplAccessor;
import net.blay09.mods.forgivingvoid.mixin.ServerPlayerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";

    public static void initialize() {
        ForgivingVoidConfig.initialize();
        Balm.getEvents().onEvent(LivingFallEvent.class, ForgivingVoid::onPlayerFall);
        Balm.getEvents().onTickEvent(TickType.ServerPlayer, TickPhase.Start, ForgivingVoid::onPlayerTick);
    }

    public static void onPlayerTick(ServerPlayer player) {
        int triggerAtY = player.level().getMinBuildHeight() - ForgivingVoidConfig.getActive().triggerAtDistanceBelow;
        boolean isInVoid = player.getY() < (double)triggerAtY && player.yo < (double)triggerAtY;
        boolean isTeleporting = ((ServerGamePacketListenerImplAccessor)player.connection).getAwaitingPositionFromClient() != null;
        CompoundTag persistentData = Balm.getHooks().getPersistentData((Player)player);
        if (ForgivingVoid.isEnabledForDimension((ResourceKey<Level>)player.level().dimension()) && isInVoid && !isTeleporting && ForgivingVoid.fireForgivingVoidEvent((Player)player)) {
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 3));
            if (player.isVehicle()) {
                player.ejectPassengers();
            }
            player.stopRiding();
            ((ServerPlayerAccessor)player).setIsChangingDimension(true);
            player.teleportTo(player.getX(), (double)ForgivingVoidConfig.getActive().fallingHeight, player.getZ());
            persistentData.putBoolean("ForgivingVoidIsFalling", true);
        } else if (persistentData.getBoolean("ForgivingVoidIsFalling")) {
            BlockPos playerPos = player.blockPosition();
            if (player.isInWater() || player.onGround() || player.getAbilities().flying || player.getAbilities().mayfly || player.level().getBlockState(playerPos).getBlock() == Blocks.COBWEB) {
                persistentData.putBoolean("ForgivingVoidIsFalling", false);
                ((ServerPlayerAccessor)player).setIsChangingDimension(false);
                return;
            }
            if (ForgivingVoidConfig.getActive().disableVanillaAntiCheatWhileFalling) {
                ((ServerPlayerAccessor)player).setIsChangingDimension(true);
            }
        }
    }

    public static void onPlayerFall(LivingFallEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            CompoundTag persistentData = Balm.getHooks().getPersistentData((Player)player);
            if (persistentData.getBoolean("ForgivingVoidIsFalling")) {
                float damage = ForgivingVoidConfig.getActive().damageOnFall;
                if (ForgivingVoidConfig.getActive().preventDeath && player.getHealth() - damage <= 0.0f) {
                    damage = player.getHealth() - 1.0f;
                }
                event.setFallDamageOverride(Float.valueOf(damage));
                ((ServerPlayerAccessor)player).setIsChangingDimension(false);
            }
        }
    }

    private static boolean fireForgivingVoidEvent(Player player) {
        ForgivingVoidFallThroughEvent event = new ForgivingVoidFallThroughEvent(player);
        Balm.getEvents().fireEvent((Object)event);
        return !event.isCanceled();
    }

    private static boolean isEnabledForDimension(ResourceKey<Level> dimensionKey) {
        if (dimensionKey == Level.OVERWORLD) {
            return ForgivingVoidConfig.getActive().triggerInOverworld;
        }
        if (dimensionKey == Level.END) {
            return ForgivingVoidConfig.getActive().triggerInEnd;
        }
        if (dimensionKey == Level.NETHER) {
            return ForgivingVoidConfig.getActive().triggerInNether;
        }
        ResourceLocation dimension = dimensionKey.location();
        List<String> dimensionAllowList = ForgivingVoidConfig.getActive().dimensionAllowList;
        List<String> dimensionDenyList = ForgivingVoidConfig.getActive().dimensionDenyList;
        if (!dimensionAllowList.isEmpty() && !dimensionAllowList.contains(dimension.toString())) {
            return false;
        }
        return !dimensionDenyList.contains(dimension.toString());
    }
}

