/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.forgivingvoid;

import java.util.List;
import net.blay09.mods.forgivingvoid.ForgivingVoidConfig;
import net.blay09.mods.forgivingvoid.ForgivingVoidEvent;
import net.blay09.mods.forgivingvoid.compat.GameStagesCompat;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="forgivingvoid")
@Mod.EventBusSubscriber
public class ForgivingVoid {
    public static final String MOD_ID = "forgivingvoid";

    public ForgivingVoid() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ForgivingVoidConfig.commonSpec);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    public void setup(FMLCommonSetupEvent event) {
        ModList.get().getModObjectById("gamestages").ifPresent(it -> new GameStagesCompat());
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            boolean isTeleporting;
            boolean isInVoid = event.player.func_226278_cu_() < (double)((Integer)ForgivingVoidConfig.COMMON.triggerAtY.get()).intValue() && event.player.field_70167_r < (double)((Integer)ForgivingVoidConfig.COMMON.triggerAtY.get()).intValue();
            boolean bl = isTeleporting = ((ServerPlayerEntity)event.player).field_71135_a.field_184362_y != null;
            if (ForgivingVoid.isEnabledForDimension((RegistryKey<World>)event.player.field_70170_p.func_234923_W_()) && isInVoid && !isTeleporting && ForgivingVoid.fireForgivingVoidEvent(event.player)) {
                event.player.func_195064_c(new EffectInstance(Effects.field_76440_q, 60, 3));
                if (event.player.func_184207_aI()) {
                    event.player.func_184226_ay();
                }
                event.player.func_184210_p();
                ((ServerPlayerEntity)event.player).field_184851_cj = true;
                event.player.func_70634_a(event.player.func_226277_ct_(), (double)((Integer)ForgivingVoidConfig.COMMON.fallingHeight.get()).intValue(), event.player.func_226281_cx_());
                event.player.getPersistentData().func_74757_a("ForgivingVoidNoFallDamage", true);
            } else if (event.player.getPersistentData().func_74767_n("ForgivingVoidNoFallDamage")) {
                BlockPos playerPos = event.player.func_233580_cy_();
                if (event.player.func_70090_H() || event.player.field_71075_bZ.field_75100_b || event.player.field_71075_bZ.field_75101_c || event.player.field_70170_p.func_180495_p(playerPos).func_177230_c() == Blocks.field_196553_aF) {
                    event.player.getPersistentData().func_74757_a("ForgivingVoidNoFallDamage", false);
                    ((ServerPlayerEntity)event.player).field_184851_cj = false;
                    return;
                }
                if (((Boolean)ForgivingVoidConfig.COMMON.disableVanillaAntiCheatWhileFalling.get()).booleanValue()) {
                    ((ServerPlayerEntity)event.player).field_184851_cj = true;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void onPlayerFall(LivingFallEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity && event.getEntity().getPersistentData().func_74767_n("ForgivingVoidNoFallDamage")) {
            if (((Boolean)ForgivingVoidConfig.COMMON.disableVanillaAntiCheatWhileFalling.get()).booleanValue()) {
                ((ServerPlayerEntity)event.getEntity()).field_184851_cj = false;
            }
            if (!event.isCanceled()) {
                float finalDamage;
                float damage = ((Integer)ForgivingVoidConfig.COMMON.damageOnFall.get()).intValue();
                if (((Boolean)ForgivingVoidConfig.COMMON.preventDeath.get()).booleanValue() && event.getEntityLiving().func_110143_aJ() - damage <= 0.0f) {
                    damage = event.getEntityLiving().func_110143_aJ() - 1.0f;
                }
                if ((finalDamage = damage * event.getDamageMultiplier()) > 0.0f) {
                    event.getEntity().func_70097_a(DamageSource.field_76379_h, finalDamage);
                }
            }
            event.setDamageMultiplier(0.0f);
            event.setCanceled(true);
            event.getEntity().getPersistentData().func_74757_a("ForgivingVoidNoFallDamage", false);
        }
    }

    private static boolean fireForgivingVoidEvent(PlayerEntity player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new ForgivingVoidEvent(player));
    }

    private static boolean isEnabledForDimension(RegistryKey<World> dimension) {
        if (dimension == World.field_234918_g_) {
            return (Boolean)ForgivingVoidConfig.COMMON.triggerInOverworld.get();
        }
        if (dimension == World.field_234920_i_) {
            return (Boolean)ForgivingVoidConfig.COMMON.triggerInEnd.get();
        }
        if (dimension == World.field_234919_h_) {
            return (Boolean)ForgivingVoidConfig.COMMON.triggerInNether.get();
        }
        ResourceLocation resourceLocation = dimension.func_240901_a_();
        return ((Boolean)ForgivingVoidConfig.COMMON.dimensionBlacklistIsWhitelist.get()).booleanValue() == ((List)ForgivingVoidConfig.COMMON.dimensionBlacklist.get()).contains(resourceLocation.toString());
    }
}

