/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.config;

import bre2el.fpsreducer.config.ConfigManager;
import bre2el.fpsreducer.gui.HudPos;
import bre2el.fpsreducer.util.Logger;

public class Config {
    private static Config config = new Config();
    public boolean enableFpsReducer;
    public int waitingTime;
    public int idleFps;
    public int guiScreenFps;
    public int detectMoving;
    public static final int DETECTMOVING_OFF = 0;
    public static final int DETECTMOVING_RIDING_FLYING = 1;
    public static final int DETECTMOVING_ON = 2;
    public boolean ignoreHoldButton;
    public boolean reducingInBackground;
    public boolean suppressSound;
    public int suppressedVolume;
    public boolean hudEnabled;
    private int hudReferencePos;
    public HudPos[] hudPos = new HudPos[9];
    public double hudScale;
    public int hudBehindChatBox;
    public static final int HUD_BEFIND_CHATBOX_KEEP = 0;
    public static final int HUD_BEHIND_CHATBOX_OFF = 1;
    public static final int HUD_BEHIND_CHATBOX_DODGE = 2;
    public int hudInfo;
    public static final int HUD_INFO_DISABLED = 0;
    public static final int HUD_INFO_FPS_CPU_LONG = 1;
    public static final int HUD_INFO_FPS_CPU_SHORT = 2;
    public static final int HUD_INFO_FPS_CPU_2LINES = 3;
    public static final int HUD_INFO_FPS_ONLY = 4;
    public static final int HUD_INFO_CPU_ONLY = 5;
    protected transient HudPos[] hudPosDefault = new HudPos[9];
    public transient HudPos curHudPos;
    public String hudColor;
    public String hudPreText = "FPS: ";
    public String hudReductionColor;
    public String hudReductionPreText = "ECO: ";
    public String hudGuiModeColor;
    public String hudGuiModePreText = "FPS: ";
    private final transient String COLOR_IDLE = "00f000";
    private final transient String COLOR_NORMAL = "f0f0f0";
    private final transient String COLOR_GUI = "00f0f0";
    public int cpuUsageType;
    public static final int CPU_USAGE_TYPE_ONE_CPU_BASIS = 0;
    public static final int CPU_USAGE_TYPE_ALL_CPU_BASIS = 1;
    public int cpuUsageThread;
    public static final int CPU_USAGE_THREAD_CLIENT_ONLY = 0;
    public static final int CPU_USAGE_THREAD_ALL = 1;
    public boolean allowOneFps;
    public transient boolean noWaitRecovery = true;
    public boolean debugLog;
    public boolean logInChat;
    public transient int hudColorDec;
    public transient int hudReductionColorDec;
    public transient int hudGuiModeColorDec;

    public Config() {
        int i;
        for (i = 0; i < 9; ++i) {
            this.hudPos[i] = new HudPos(i);
            this.hudPosDefault[i] = new HudPos(i);
        }
        this.initDefaultValues();
        this.enableFpsReducer = true;
        this.waitingTime = 300;
        this.idleFps = 10;
        this.guiScreenFps = 0;
        this.detectMoving = 1;
        this.ignoreHoldButton = false;
        this.reducingInBackground = true;
        this.suppressSound = true;
        this.suppressedVolume = 20;
        this.hudEnabled = true;
        this.hudReferencePos = 3;
        this.hudScale = 1.0;
        this.hudBehindChatBox = 2;
        this.hudInfo = 4;
        for (i = 0; i < 8; ++i) {
            this.hudPos[i + 1] = this.hudPosDefault[i + 1].copy();
        }
        this.hudColor = "f0f0f0";
        this.hudReductionColor = "00f000";
        this.hudGuiModeColor = "00f0f0";
        this.cpuUsageType = 0;
        this.cpuUsageThread = 0;
        this.allowOneFps = false;
        this.debugLog = false;
        this.logInChat = false;
        this.update();
    }

    public void update() {
        this.setHudReferencePos(this.hudReferencePos);
        this.hudColorDec = Config.hexToDec("f0f0f0", 0xF0F0F0);
        this.hudReductionColorDec = Config.hexToDec("00f000", 61440);
        this.hudGuiModeColorDec = Config.hexToDec("00f0f0", 61680);
    }

    public void prepareSave() {
        this.hudColor = Config.decToHex(this.hudColorDec);
        this.hudReductionColor = Config.decToHex(this.hudReductionColorDec);
        this.hudGuiModeColor = Config.decToHex(this.hudGuiModeColorDec);
    }

    protected void initDefaultValues() {
        this.hudPosDefault[1].setOffset(2, 2);
        this.hudPosDefault[2].setOffset(0, 2);
        this.hudPosDefault[3].setOffset(-2, 2);
        this.hudPosDefault[4].setOffset(-2, 0);
        this.hudPosDefault[5].setOffset(-2, -2);
        this.hudPosDefault[6].setOffset(0, -2);
        this.hudPosDefault[7].setOffset(2, -2);
        this.hudPosDefault[8].setOffset(2, 0);
        this.hudPosDefault[1].alignment = 0;
        this.hudPosDefault[2].alignment = 2;
        this.hudPosDefault[3].alignment = 1;
        this.hudPosDefault[4].alignment = 1;
        this.hudPosDefault[5].alignment = 1;
        this.hudPosDefault[6].alignment = 2;
        this.hudPosDefault[7].alignment = 0;
        this.hudPosDefault[8].alignment = 0;
    }

    public static Config getInstance() {
        return config;
    }

    public static void setInstance(Config newConf) {
        config = newConf;
    }

    public void setHudReferencePos(int loc) {
        this.hudReferencePos = loc;
        this.curHudPos = this.hudPos[loc];
    }

    public int getHudReferencePos() {
        return this.hudReferencePos;
    }

    public void resetHudOffsetsAndAlignments() {
        for (int i = 0; i < 8; ++i) {
            this.hudPos[i + 1].setOffset(this.hudPosDefault[i + 1].offsetX, this.hudPosDefault[i + 1].offsetY);
            this.hudPos[i + 1].alignment = this.hudPosDefault[i + 1].alignment;
        }
        ConfigManager.save();
    }

    private static int hexToDec(String hexString, int defaultVal) {
        int intValue;
        try {
            intValue = Integer.parseInt(hexString, 16);
        }
        catch (NumberFormatException ne) {
            Logger.error("Parsing configuration error: " + hexString);
            return defaultVal;
        }
        return intValue;
    }

    private static String decToHex(int intValue) {
        String hexString = String.format("%06x", intValue);
        return hexString;
    }
}

