/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui.components;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.components.DelayedTooltip;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_357;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

@Environment(value=EnvType.CLIENT)
public class GuiSlider
extends class_357
implements DelayedTooltip {
    protected String prefix;
    protected String suffix;
    protected double minVal;
    protected double maxVal;
    protected boolean showDec;
    protected boolean showText;
    protected Map<Double, String> additionalText = new HashMap<Double, String>();
    protected Map<Double, String> substituteText = new HashMap<Double, String>();
    protected ISlider applyValueHandler;
    protected ISlider releaseHandler;
    protected List<class_5481> tooltip;
    private long hoverStartTime;
    private int resolution = 1;

    public GuiSlider(int xIn, int yIn, int widthIn, int heightIn, String prefix, String suffix, double minVal, double maxVal, double curVal, boolean showDec, boolean showText, ISlider applyValueHandler, ISlider releaseHandler) {
        super(xIn, yIn, widthIn, heightIn, class_2561.method_30163((String)""), (curVal - minVal) / (maxVal - minVal));
        this.prefix = prefix;
        this.suffix = suffix;
        this.minVal = minVal;
        this.maxVal = maxVal;
        this.showDec = showDec;
        this.showText = showText;
        this.applyValueHandler = applyValueHandler;
        this.releaseHandler = releaseHandler;
        this.method_25346();
    }

    public GuiSlider addSubstituteText(double val, String text) {
        this.substituteText.put(val, text);
        this.method_25346();
        return this;
    }

    public GuiSlider addAdditionalText(double val, String text) {
        this.additionalText.put(val, text);
        this.method_25346();
        return this;
    }

    protected void method_25346() {
        String message;
        double dispVal;
        if (this.showDec) {
            dispVal = (double)((int)(this.getValue() * 10.0)) / 10.0;
            message = this.prefix + dispVal + this.suffix;
        } else {
            dispVal = this.getValueInt();
            message = this.prefix + (int)dispVal + this.suffix;
        }
        if (this.showText) {
            double keyVal;
            for (Map.Entry<Double, String> entry : this.substituteText.entrySet()) {
                keyVal = entry.getKey();
                if (!this.showDec) {
                    keyVal = Math.round(keyVal);
                }
                if (dispVal != keyVal) continue;
                message = this.prefix + entry.getValue();
                break;
            }
            for (Map.Entry<Double, String> entry : this.additionalText.entrySet()) {
                keyVal = entry.getKey();
                if (!this.showDec) {
                    keyVal = Math.round(keyVal);
                }
                if (dispVal != entry.getKey()) continue;
                message = message + " (" + entry.getValue() + ")";
                break;
            }
            this.method_25355(class_2561.method_30163((String)message));
        }
    }

    public void method_25357(double posX, double posY) {
        super.method_25357(posX, posY);
        if (this.releaseHandler != null) {
            this.releaseHandler.action(this);
        }
    }

    protected void method_25344() {
        if (this.applyValueHandler != null) {
            this.applyValueHandler.action(this);
            Config.getInstance().correctProfile();
        }
    }

    public int getValueInt() {
        int val = (int)Math.round(this.field_22753 * (this.maxVal - this.minVal) + this.minVal);
        return Math.round(val / this.resolution) * this.resolution;
    }

    public double getValue() {
        return this.field_22753 * (this.maxVal - this.minVal) + this.minVal;
    }

    public GuiSlider setResolution(int resolution) {
        this.resolution = resolution;
        return this;
    }

    public GuiSlider setTooltip(class_2561 tooltip) {
        this.tooltip = class_310.method_1551().field_1772.method_1728((class_5348)tooltip, 200);
        return this;
    }

    public List<class_5481> method_31047() {
        return this.tooltip;
    }

    @Override
    public void setHoverTime() {
        this.hoverStartTime = System.currentTimeMillis();
    }

    @Override
    public long getHoverTime() {
        return this.hoverStartTime;
    }

    @Override
    public void clearHoverTime() {
        this.hoverStartTime = 0L;
    }

    public static interface ISlider {
        public void action(GuiSlider var1);
    }
}

