/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.handler.GuiOpenEventHandler;
import bre2el.fpsreducer.handler.glfw.InputEventHandler;
import bre2el.fpsreducer.util.GlfwUtils;
import bre2el.fpsreducer.util.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

public class WakeupEventHandler {
    public static WakeupEventHandler INSTANCE = new WakeupEventHandler();
    private Minecraft mc = Minecraft.m_91087_();
    private long windowHandle = this.mc.m_91268_().m_85439_();
    private int maxFPS;
    private long idleStartTime;
    private float currentGameSettingVolume;
    private boolean stopSound = false;
    public int fpsMode;
    public static final int MODE_IDLE = 0;
    public static final int MODE_NORMAL = 1;
    public static final int MODE_GUI = 2;
    public static final int MODE_NOACT = 3;
    public boolean cancelableWaitEvents;
    private long prevInputEventNanoSec;
    private int prevWindowAttrib = 1;
    private long prevMovingEventMilliSec;
    private double prevX;
    private double prevY;
    private double prevZ;
    private float prevRotationYaw;
    private float prevRotationPitch;
    private int tpsCounter = 0;
    private long prevUpdateTime;
    private int curTps;
    private String prevReason = "";

    public WakeupEventHandler() {
        Options cfr_ignored_0 = Minecraft.m_91087_().f_91066_;
        this.maxFPS = 260;
        Logger.debug("MaxFramerate=", this.maxFPS);
        this.fpsMode = 1;
        InputEventHandler.INSTANCE.addCallbacks();
    }

    @SubscribeEvent
    public void onMouseClicked(ScreenEvent.MouseButtonPressed.Pre event) {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("mouse clicked");
    }

    @SubscribeEvent
    public void onMouseScroll(ScreenEvent.MouseScrolled.Pre event) {
        if (GlfwUtils.isWindowFocused() || !Config.CURRENT.reducingInBackground) {
            this.makeWindowStatusActive();
            this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
            this.resetWaitingTimer();
            this.recoverFPS("mouse wheel");
        }
    }

    @SubscribeEvent
    public void onKeyboardKeyPressed(ScreenEvent.KeyPressed.Pre event) {
        this.makeWindowStatusActive();
        this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
        this.resetWaitingTimer();
        this.recoverFPS("key pressed event");
    }

    private void makeWindowStatusActive() {
        if (this.prevWindowAttrib == 0) {
            Logger.debug("Window has been active. (onInputEvent)");
        }
        this.prevWindowAttrib = 1;
        this.recoverSound();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.checkWakeupEvent();
            this.calcTps();
        }
    }

    private void calcTps() {
        ++this.tpsCounter;
        long curTime = System.currentTimeMillis();
        long elapsedTime = curTime - this.prevUpdateTime;
        if (elapsedTime >= 1000L) {
            this.curTps = Math.round((float)this.tpsCounter * (1000.0f / (float)elapsedTime));
            this.tpsCounter = 0;
            this.prevUpdateTime = curTime;
        }
    }

    public int getTps() {
        return this.curTps;
    }

    private void checkWakeupEvent() {
        block20: {
            if (this.fpsMode != 0) {
                this.cancelableWaitEvents = false;
            }
            if (!Config.CURRENT.enableFpsReducer) {
                this.resetWaitingTimer();
                this.recoverNormalFPS("FPS Reducer disabled");
                return;
            }
            if (Config.CURRENT.reducingInBackground || Config.CURRENT.suppressSound) {
                int curWindowAttrib = GLFW.glfwGetWindowAttrib((long)this.windowHandle, (int)131073);
                if (curWindowAttrib == 0) {
                    if (curWindowAttrib != this.prevWindowAttrib) {
                        Logger.debug("Window has been inactive. (onClientTick)");
                        this.prevWindowAttrib = curWindowAttrib;
                        if (Config.CURRENT.suppressSound) {
                            this.stopSound();
                        }
                    }
                    if (Config.CURRENT.reducingInBackground) {
                        this.reduceFPS(0, "Window has been inactive.");
                        return;
                    }
                } else if (curWindowAttrib != this.prevWindowAttrib) {
                    Logger.debug("Window has been active. (onClientTick)");
                    this.prevInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
                    this.prevWindowAttrib = curWindowAttrib;
                    this.recoverSound();
                }
            }
            if (this.mc.f_91073_ == null) {
                this.resetWaitingTimer();
                this.recoverFPS("world is null");
                return;
            }
            long currentInputEventNanoSec = InputEventHandler.INSTANCE.getLastEventNanoSec();
            if (currentInputEventNanoSec > this.prevInputEventNanoSec) {
                this.prevInputEventNanoSec = currentInputEventNanoSec;
                this.resetWaitingTimer();
                this.recoverFPS("GLFW input event");
                return;
            }
            try {
                if (this.mc.f_91074_.f_108618_.f_108568_ || this.mc.f_91074_.f_108618_.f_108569_ || this.mc.f_91074_.f_108618_.f_108571_ || this.mc.f_91074_.f_108618_.f_108570_ || this.mc.f_91074_.f_108618_.f_108572_ || this.mc.f_91074_.f_108618_.f_108573_) {
                    this.resetWaitingTimer();
                    this.recoverFPS("movement input");
                    return;
                }
            }
            catch (NullPointerException e) {
                if (!Config.GLOBAL.debugLog) break block20;
                e.printStackTrace();
            }
        }
        if (!Config.CURRENT.ignoreHoldButton) {
            for (int btn = 0; btn <= 7; ++btn) {
                int state = GLFW.glfwGetMouseButton((long)this.windowHandle, (int)btn);
                if (state != 1) continue;
                this.resetWaitingTimer();
                this.recoverFPS("keep mouse button pressed");
                break;
            }
        }
        switch (Config.CURRENT.detectMoving) {
            case 1: {
                if (this.mc.f_91074_ == null || this.mc.f_91074_.m_20096_() || !this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement riding/flying");
                return;
            }
            case 2: {
                if (!this.checkMovingSimply() && !this.checkRotation()) break;
                this.resetWaitingTimer();
                this.recoverFPS("detected movement");
                return;
            }
        }
        this.checkWaitingTimer();
    }

    public static void checkWakeup() {
        INSTANCE.checkWakeupEvent();
    }

    private boolean checkMoving() {
        int interval = 1000;
        long curMovingEventMilliSec = System.currentTimeMillis();
        if (curMovingEventMilliSec - this.prevMovingEventMilliSec >= 1000L & this.mc.f_91074_ != null) {
            double posX = this.mc.f_91074_.m_20185_();
            double posY = this.mc.f_91074_.m_20186_();
            double posZ = this.mc.f_91074_.m_20189_();
            double mx = posX - this.prevX;
            double my = posY - this.prevY;
            double mz = posZ - this.prevZ;
            double movement = mx * mx + my * my + mz * mz;
            Logger.debug("movement:" + Math.sqrt(movement));
            this.prevX = posX;
            this.prevY = posY;
            this.prevZ = posZ;
            this.prevMovingEventMilliSec = curMovingEventMilliSec;
            double threshold = 0.9;
            return movement >= threshold * threshold;
        }
        return false;
    }

    private boolean checkMovingSimply() {
        if (this.mc.f_91074_ != null) {
            double posX = this.mc.f_91074_.m_20185_();
            double posY = this.mc.f_91074_.m_20186_();
            double posZ = this.mc.f_91074_.m_20189_();
            if (this.prevX != posX || this.prevY != posY || this.prevZ != posZ) {
                this.prevX = posX;
                this.prevY = posY;
                this.prevZ = posZ;
                return true;
            }
        }
        return false;
    }

    private boolean checkRotation() {
        if (this.mc.f_91074_ != null && (this.prevRotationYaw != this.mc.f_91074_.m_146908_() || this.prevRotationPitch != this.mc.f_91074_.m_146909_())) {
            this.prevRotationYaw = this.mc.f_91074_.m_146908_();
            this.prevRotationPitch = this.mc.f_91074_.m_146909_();
            return true;
        }
        return false;
    }

    private void resetWaitingTimer() {
        this.idleStartTime = System.currentTimeMillis();
    }

    private void checkWaitingTimer() {
        int waitingMs = Config.CURRENT.waitingTime * 1000;
        long idleTime = System.currentTimeMillis() - this.idleStartTime;
        if (Config.CURRENT.reducingInGameMenu && GuiOpenEventHandler.guiGameMenuOpened) {
            waitingMs = 200;
        }
        if (this.fpsMode != 0) {
            if (waitingMs != 0 && idleTime > (long)waitingMs) {
                this.reduceFPS(0, "Waiting time has been expired.");
            } else if (this.fpsMode != 3 & Config.CURRENT.noActFps > 0 & idleTime > 500L) {
                this.reduceFPS(3, "No action was detected within 200ms.");
            }
        }
    }

    private void reduceFPS(int mode, String reason) {
        switch (mode) {
            case 0: 
            case 2: {
                if (this.fpsMode == 0) break;
                if (GuiOpenEventHandler.guiOpened && Config.CURRENT.guiScreenFps != 0 && Config.CURRENT.guiScreenFps <= Config.CURRENT.idleFps) {
                    this.setFramerateLimit(Config.CURRENT.guiScreenFps, 2);
                } else {
                    this.setFramerateLimit(Config.CURRENT.idleFps, 0);
                    this.setCancelableWaitEvents();
                    InputEventHandler.INSTANCE.clearInputEventInIdle();
                }
                this.loggingReduceFps(reason);
                break;
            }
            case 3: {
                if (Config.CURRENT.noActFps <= 0 || this.fpsMode != 1 && (this.fpsMode != 2 || Config.CURRENT.noActFps >= Config.CURRENT.guiScreenFps)) break;
                this.setFramerateLimit(Config.CURRENT.noActFps, 3);
                this.loggingReduceFps(reason);
                break;
            }
        }
    }

    private void recoverFPS(String reason) {
        if (this.fpsMode != 1) {
            if (GuiOpenEventHandler.guiOpened && Config.CURRENT.guiScreenFps != 0) {
                this.setFramerateLimit(Config.CURRENT.guiScreenFps, 2);
            } else {
                this.setFramerateLimit((Integer)this.mc.f_91066_.m_232035_().m_231551_(), 1);
            }
            this.loggingRecoverFps(reason);
        }
    }

    private void recoverNormalFPS(String reason) {
        if (this.fpsMode != 1) {
            this.setFramerateLimit((Integer)this.mc.f_91066_.m_232035_().m_231551_(), 1);
            this.loggingRecoverFps(reason);
        }
    }

    private void loggingReduceFps(String reason) {
        if (Config.GLOBAL.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            Logger.debug("Reducing max FPS: ", this.mc.m_91268_().m_85434_(), " (reason: ", reason, ")");
        }
    }

    private void loggingRecoverFps(String reason) {
        if (Config.GLOBAL.debugLog && !this.prevReason.equals(reason)) {
            this.prevReason = reason;
            int framerateLimit = this.mc.m_91268_().m_85434_();
            if (framerateLimit == this.maxFPS) {
                Logger.debug("Recovering max FPS: Unlimited (reason: ", reason, ")");
            } else {
                Logger.debug("Recovering max FPS: ", framerateLimit, " (reason: ", reason, ")");
            }
        }
    }

    public void forceReduceFPS(int mode, String reason) {
        this.reduceFPS(mode, "[force reduce] " + reason);
    }

    public void forceRecoverFPS(String reason) {
        this.fpsMode = 2;
        this.resetWaitingTimer();
        this.recoverFPS("[force recover] " + reason);
    }

    private void stopSound() {
        if (!this.stopSound) {
            this.currentGameSettingVolume = this.mc.f_91066_.m_92147_(SoundSource.MASTER);
            float newVolume = this.currentGameSettingVolume * (float)Config.CURRENT.suppressedVolume / 100.0f;
            this.mc.f_91066_.m_92149_(SoundSource.MASTER, newVolume);
            this.stopSound = true;
            Logger.debug("Suppressing master volume: ", (int)(newVolume * 100.0f));
        }
    }

    private void recoverSound() {
        if (this.stopSound) {
            this.mc.f_91066_.m_92149_(SoundSource.MASTER, this.currentGameSettingVolume);
            this.stopSound = false;
            Logger.debug("Recovering master volume: ", (int)(this.currentGameSettingVolume * 100.0f));
        }
    }

    private int getWaitingTimeSecond() {
        return (int)(System.currentTimeMillis() - this.idleStartTime) / 1000;
    }

    private void setCancelableWaitEvents() {
        if (Config.GLOBAL.noWaitRecovery) {
            this.cancelableWaitEvents = true;
        }
    }

    private void setFramerateLimit(int framerateLimit, int mode) {
        this.mc.m_91268_().m_85380_(framerateLimit);
        this.fpsMode = mode;
    }
}

