/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.handler;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.Hud;
import bre2el.fpsreducer.util.ModLib;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class OverlayEventHandler {
    private Minecraft mc = Minecraft.m_91087_();
    private int fpsCounter = 0;
    private long prevUpdateTime = 0L;

    @SubscribeEvent
    public void onRenderGameOverlay(CustomizeGuiOverlayEvent event) {
        if (!(event instanceof CustomizeGuiOverlayEvent.DebugText)) {
            return;
        }
        if (!Config.CURRENT.hudEnabled) {
            return;
        }
        ++this.fpsCounter;
        long curTime = System.currentTimeMillis();
        long elapsedTime = curTime - this.prevUpdateTime;
        if (elapsedTime >= 1000L) {
            int curFPS = Math.round((float)this.fpsCounter * (1000.0f / (float)elapsedTime));
            this.fpsCounter = 0;
            double cpuLoad = Config.GLOBAL.cpuUsageThread == 0 ? ModLib.getThreadCpuUsage(Config.GLOBAL.cpuUsageType == 1) : ModLib.getCpuUsage(Config.GLOBAL.cpuUsageType == 1);
            Hud.getInstance().setFPSCPUData(curFPS, cpuLoad);
            Hud.getInstance().updateHudText();
            this.prevUpdateTime = curTime;
        }
        if (!this.mc.m_293199_().m_294516_()) {
            Hud.getInstance().drawHud(event.getGuiGraphics(), this.mc.m_91268_().m_85445_(), this.mc.m_91268_().m_85446_(), this.fpsCounter == 0);
        }
    }
}

