/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels;

import com.chrisgli.gemsnjewels.CommonProxy;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

@Mod(modid="gemsnjewels", name="Gems & Jewels", version="1.0.8")
public class Main {
    public static final String MODID = "gemsnjewels";
    public static final String MODNAME = "Gems & Jewels";
    public static final String VERSION = "1.0.8";
    public static Configuration config;
    public static Map<String, Boolean> cGemEnabledMap;
    public static Map<String, Boolean> cNetherGemEnabledMap;
    public static Map<String, String[]> cGemBiomeSpecMap;
    public static boolean isGemsToEmeraldsEnabled;
    public static boolean isVillagerFollowEmeraldBlockEnabled;
    public static boolean isGemInfusedSwordsEnabled;
    public static int infusedSwordKillsPerLevel;
    public static int infusedSwordLevelCap;
    public static boolean isSilverAlloyRecipeEnabled;
    @SidedProxy(clientSide="com.chrisgli.gemsnjewels.ClientProxy", serverSide="com.chrisgli.gemsnjewels.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Main instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        Main.syncConfig();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    public static void syncConfig() {
        try {
            config.load();
            Main.loadBiomeSpecProps();
            Main.loadOWGemEnabledProps();
            Main.loadNGemEnabledProps();
            Main.loadEmeraldBlockProps();
            Main.loadInfusedSwordProps();
            Property isSilverAlloyRecipeEnabledProp = config.get("silver alloy recipe", "isSilverAlloyRecipeEnabled", "true");
            isSilverAlloyRecipeEnabled = isSilverAlloyRecipeEnabledProp.getBoolean();
        }
        catch (Exception exception) {
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void loadInfusedSwordProps() {
        Property isGemInfusedSwordsEnabledProp = config.get("gem infused steel swords", "isGemInfusedSwordsEnabled", "true");
        isGemInfusedSwordsEnabled = isGemInfusedSwordsEnabledProp.getBoolean();
        Property infusedSwordKPLProp = config.get("gem infused steel swords", "infusedSwordKillsPerLevel", 10, "number of kills per sword damage increase (EX: 10 kills per +1 damage); -1 for exponential scaling (2, 4, 8, 16, 32, 64...)");
        infusedSwordKillsPerLevel = infusedSwordKPLProp.getInt();
        Property infusedSwordLevelCapProp = config.get("gem infused steel swords", "infusedSwordLevelCap", 9, "maximum sword damage bonus from kills; -1 for no limit");
        infusedSwordLevelCap = infusedSwordLevelCapProp.getInt();
    }

    public static void loadEmeraldBlockProps() {
        Property isVillagerFollowEmeraldBlockProp = config.get("emerald block", "isVillagerFollowEmeraldBlockEnabled", "true");
        isVillagerFollowEmeraldBlockEnabled = isVillagerFollowEmeraldBlockProp.getBoolean();
        Property isGemsToEmeraldsEnabledProp = config.get("emerald block", "isGemsToEmeraldsEnabled", "false");
        isGemsToEmeraldsEnabled = isGemsToEmeraldsEnabledProp.getBoolean();
    }

    public static void loadNGemEnabledProps() {
        Property isDiamondEnabledProp = config.get("nether generation", "isDiamondEnabled", "true");
        cNetherGemEnabledMap.put("diamond", isDiamondEnabledProp.getBoolean());
        Property isEmeraldEnabledProp = config.get("nether generation", "isEmeraldEnabled", "true");
        cNetherGemEnabledMap.put("emerald", isEmeraldEnabledProp.getBoolean());
        Property isRubyEnabledProp = config.get("nether generation", "isRubyEnabled", "true");
        cNetherGemEnabledMap.put("ruby", isRubyEnabledProp.getBoolean());
        Property isSapphireEnabledProp = config.get("nether generation", "isSapphireEnabled", "true");
        cNetherGemEnabledMap.put("sapphire", isSapphireEnabledProp.getBoolean());
        Property isAmethystEnabledProp = config.get("nether generation", "isAmethystEnabled", "true");
        cNetherGemEnabledMap.put("amethyst", isAmethystEnabledProp.getBoolean());
        Property isOpalEnabledProp = config.get("nether generation", "isOpalEnabled", "true");
        cNetherGemEnabledMap.put("opal", isOpalEnabledProp.getBoolean());
        Property isGarnetEnabledProp = config.get("nether generation", "isGarnetEnabled", "true");
        cNetherGemEnabledMap.put("garnet", isGarnetEnabledProp.getBoolean());
        Property isTopazEnabledProp = config.get("nether generation", "isTopazEnabled", "true");
        cNetherGemEnabledMap.put("topaz", isTopazEnabledProp.getBoolean());
        Property isPeridotEnabledProp = config.get("nether generation", "isPeridotEnabled", "true");
        cNetherGemEnabledMap.put("peridot", isPeridotEnabledProp.getBoolean());
        Property isAquamarineEnabledProp = config.get("nether generation", "isAquamarineEnabled", "true");
        cNetherGemEnabledMap.put("aquamarine", isAquamarineEnabledProp.getBoolean());
        Property isZirconEnabledProp = config.get("nether generation", "isZirconEnabled", "true");
        cNetherGemEnabledMap.put("zircon", isZirconEnabledProp.getBoolean());
        Property isAlexandriteEnabledProp = config.get("nether generation", "isAlexandriteEnabled", "true", "whether gem ore generates in the nether");
        cNetherGemEnabledMap.put("alexandrite", isAlexandriteEnabledProp.getBoolean());
        Property isTanzaniteEnabledProp = config.get("nether generation", "isTanzaniteEnabled", "true");
        cNetherGemEnabledMap.put("tanzanite", isTanzaniteEnabledProp.getBoolean());
        Property isTourmalineEnabledProp = config.get("nether generation", "isTourmalineEnabled", "true");
        cNetherGemEnabledMap.put("tourmaline", isTourmalineEnabledProp.getBoolean());
        Property isSpinelEnabledProp = config.get("nether generation", "isSpinelEnabled", "true");
        cNetherGemEnabledMap.put("spinel", isSpinelEnabledProp.getBoolean());
        Property isBlackOpalEnabledProp = config.get("nether generation", "isBlackOpalEnabled", "true");
        cNetherGemEnabledMap.put("blackOpal", isBlackOpalEnabledProp.getBoolean());
        Property isJasperEnabledProp = config.get("nether generation", "isJasperEnabled", "true");
        cNetherGemEnabledMap.put("jasper", isJasperEnabledProp.getBoolean());
        Property isCitrineEnabledProp = config.get("nether generation", "isCitrineEnabled", "true");
        cNetherGemEnabledMap.put("citrine", isCitrineEnabledProp.getBoolean());
        Property isAmberEnabledProp = config.get("nether generation", "isAmberEnabled", "true");
        cNetherGemEnabledMap.put("amber", isAmberEnabledProp.getBoolean());
        Property isJadeEnabledProp = config.get("nether generation", "isJadeEnabled", "true");
        cNetherGemEnabledMap.put("jade", isJadeEnabledProp.getBoolean());
        Property isMalachiteEnabledProp = config.get("nether generation", "isMalachiteEnabled", "true");
        cNetherGemEnabledMap.put("malachite", isMalachiteEnabledProp.getBoolean());
        Property isTurquoiseEnabledProp = config.get("nether generation", "isTurquoiseEnabled", "true");
        cNetherGemEnabledMap.put("turquoise", isTurquoiseEnabledProp.getBoolean());
        Property isSugiliteEnabledProp = config.get("nether generation", "isSugiliteEnabled", "true");
        cNetherGemEnabledMap.put("sugilite", isSugiliteEnabledProp.getBoolean());
        Property isRoseQuartzEnabledProp = config.get("nether generation", "isRoseQuartzEnabled", "true");
        cNetherGemEnabledMap.put("roseQuartz", isRoseQuartzEnabledProp.getBoolean());
        Property isOnyxEnabledProp = config.get("nether generation", "isOnyxEnabled", "true");
        cNetherGemEnabledMap.put("onyx", isOnyxEnabledProp.getBoolean());
        Property isLapisEnabledProp = config.get("nether generation", "isLapisEnabled", "true");
        cNetherGemEnabledMap.put("lapis", isLapisEnabledProp.getBoolean());
    }

    public static void loadOWGemEnabledProps() {
        Property isEmeraldEnabledProp = config.get("overworld generation", "isEmeraldEnabled", "true", "whether mod generates emerald ore in the overworld; spawns in all biomes instead of only mountains");
        cGemEnabledMap.put("emerald", isEmeraldEnabledProp.getBoolean());
        Property isRubyEnabledProp = config.get("overworld generation", "isRubyEnabled", "true");
        cGemEnabledMap.put("ruby", isRubyEnabledProp.getBoolean());
        Property isSapphireEnabledProp = config.get("overworld generation", "isSapphireEnabled", "true");
        cGemEnabledMap.put("sapphire", isSapphireEnabledProp.getBoolean());
        Property isAmethystEnabledProp = config.get("overworld generation", "isAmethystEnabled", "true");
        cGemEnabledMap.put("amethyst", isAmethystEnabledProp.getBoolean());
        Property isOpalEnabledProp = config.get("overworld generation", "isOpalEnabled", "true");
        cGemEnabledMap.put("opal", isOpalEnabledProp.getBoolean());
        Property isGarnetEnabledProp = config.get("overworld generation", "isGarnetEnabled", "true");
        cGemEnabledMap.put("garnet", isGarnetEnabledProp.getBoolean());
        Property isTopazEnabledProp = config.get("overworld generation", "isTopazEnabled", "true");
        cGemEnabledMap.put("topaz", isTopazEnabledProp.getBoolean());
        Property isPeridotEnabledProp = config.get("overworld generation", "isPeridotEnabled", "true");
        cGemEnabledMap.put("peridot", isPeridotEnabledProp.getBoolean());
        Property isAquamarineEnabledProp = config.get("overworld generation", "isAquamarineEnabled", "true");
        cGemEnabledMap.put("aquamarine", isAquamarineEnabledProp.getBoolean());
        Property isZirconEnabledProp = config.get("overworld generation", "isZirconEnabled", "true");
        cGemEnabledMap.put("zircon", isZirconEnabledProp.getBoolean());
        Property isAlexandriteEnabledProp = config.get("overworld generation", "isAlexandriteEnabled", "true", "whether gem/metal ore generates in the overworld");
        cGemEnabledMap.put("alexandrite", isAlexandriteEnabledProp.getBoolean());
        Property isTanzaniteEnabledProp = config.get("overworld generation", "isTanzaniteEnabled", "true");
        cGemEnabledMap.put("tanzanite", isTanzaniteEnabledProp.getBoolean());
        Property isTourmalineEnabledProp = config.get("overworld generation", "isTourmalineEnabled", "true");
        cGemEnabledMap.put("tourmaline", isTourmalineEnabledProp.getBoolean());
        Property isSpinelEnabledProp = config.get("overworld generation", "isSpinelEnabled", "true");
        cGemEnabledMap.put("spinel", isSpinelEnabledProp.getBoolean());
        Property isBlackOpalEnabledProp = config.get("overworld generation", "isBlackOpalEnabled", "true");
        cGemEnabledMap.put("blackOpal", isBlackOpalEnabledProp.getBoolean());
        Property isJasperEnabledProp = config.get("overworld generation", "isJasperEnabled", "true");
        cGemEnabledMap.put("jasper", isJasperEnabledProp.getBoolean());
        Property isCitrineEnabledProp = config.get("overworld generation", "isCitrineEnabled", "true");
        cGemEnabledMap.put("citrine", isCitrineEnabledProp.getBoolean());
        Property isAmberEnabledProp = config.get("overworld generation", "isAmberEnabled", "true");
        cGemEnabledMap.put("amber", isAmberEnabledProp.getBoolean());
        Property isJadeEnabledProp = config.get("overworld generation", "isJadeEnabled", "true");
        cGemEnabledMap.put("jade", isJadeEnabledProp.getBoolean());
        Property isMalachiteEnabledProp = config.get("overworld generation", "isMalachiteEnabled", "true");
        cGemEnabledMap.put("malachite", isMalachiteEnabledProp.getBoolean());
        Property isTurquoiseEnabledProp = config.get("overworld generation", "isTurquoiseEnabled", "true");
        cGemEnabledMap.put("turquoise", isTurquoiseEnabledProp.getBoolean());
        Property isSugiliteEnabledProp = config.get("overworld generation", "isSugiliteEnabled", "true");
        cGemEnabledMap.put("sugilite", isSugiliteEnabledProp.getBoolean());
        Property isRoseQuartzEnabledProp = config.get("overworld generation", "isRoseQuartzEnabled", "true");
        cGemEnabledMap.put("roseQuartz", isRoseQuartzEnabledProp.getBoolean());
        Property isOnyxEnabledProp = config.get("overworld generation", "isOnyxEnabled", "true");
        cGemEnabledMap.put("onyx", isOnyxEnabledProp.getBoolean());
        Property isSilverEnabledProp = config.get("overworld generation", "isSilverEnabled", "true");
        cGemEnabledMap.put("silver", isSilverEnabledProp.getBoolean());
        Property isPlatinumEnabledProp = config.get("overworld generation", "isPlatinumEnabled", "true");
        cGemEnabledMap.put("platinum", isPlatinumEnabledProp.getBoolean());
    }

    public static void loadBiomeSpecProps() {
        Property emeraldBiomeGenProp = config.get("unique biome generation", "emeraldBiomeSpec", new String[]{"all"});
        cGemBiomeSpecMap.put("emerald", emeraldBiomeGenProp.getStringList());
        Property rubyBiomeGenProp = config.get("unique biome generation", "rubyBiomeSpec", new String[]{"all"});
        cGemBiomeSpecMap.put("ruby", rubyBiomeGenProp.getStringList());
        Property sapphireBiomeGenProp = config.get("unique biome generation", "sapphireBiomeSpec", new String[]{"all"});
        cGemBiomeSpecMap.put("sapphire", sapphireBiomeGenProp.getStringList());
        Property amethystBiomeGenProp = config.get("unique biome generation", "amethystBiomeSpec", new String[]{"all"});
        cGemBiomeSpecMap.put("amethyst", amethystBiomeGenProp.getStringList());
        Property opalBiomeGenProp = config.get("unique biome generation", "opalBiomeSpec", new String[]{"all"});
        cGemBiomeSpecMap.put("opal", opalBiomeGenProp.getStringList());
        Property garnetBiomeGenProp = config.get("unique biome generation", "garnetBiomeSpec", new String[]{"ocean", "river", "beach", "lake", "marsh", "kelp", "coral"});
        cGemBiomeSpecMap.put("garnet", garnetBiomeGenProp.getStringList());
        Property topazBiomeGenProp = config.get("unique biome generation", "topazBiomeSpec", new String[]{"mountain", "extreme", "alps", "crag", "highland", "moor", "glacier", "volcanic", "badlands", "canyon"});
        cGemBiomeSpecMap.put("topaz", topazBiomeGenProp.getStringList());
        Property peridotBiomeGenProp = config.get("unique biome generation", "peridotBiomeSpec", new String[]{"savanna", "cliffs", "tropical", "oasis", "origin", "overgrown", "scrubland", "heathland", "brushland"});
        cGemBiomeSpecMap.put("peridot", peridotBiomeGenProp.getStringList());
        Property aquamarineBiomeGenProp = config.get("unique biome generation", "aquamarineBiomeSpec", new String[]{"forest", "wooded", "fen", "orchard", "woodland", "woods"});
        cGemBiomeSpecMap.put("aquamarine", aquamarineBiomeGenProp.getStringList());
        Property zirconBiomeGenProp = config.get("unique biome generation", "zirconBiomeSpec", new String[]{"swamp", "mushroom", "bayou", "bog", "mangrove", "quagmire", "wetlands", "fungi", "silkglades", "sludgepit"});
        cGemBiomeSpecMap.put("zircon", zirconBiomeGenProp.getStringList());
        Property alexandriteBiomeGenProp = config.get("unique biome generation", "alexandriteBiomeSpec", new String[]{"taiga", "coniferous", "redwood", "shield", "temperate", "jade", "spruce"}, "which biomes to spawn gem ores in, if biome name contains listed name then the ore will spawn, <all> for every biome");
        cGemBiomeSpecMap.put("alexandrite", alexandriteBiomeGenProp.getStringList());
        Property tanzaniteBiomeGenProp = config.get("unique biome generation", "tanzaniteBiomeSpec", new String[]{"savanna", "cliffs", "tropical", "oasis", "origin", "overgrown", "scrubland", "heathland", "brushland"});
        cGemBiomeSpecMap.put("tanzanite", tanzaniteBiomeGenProp.getStringList());
        Property tourmalineBiomeGenProp = config.get("unique biome generation", "tourmalineBiomeSpec", new String[]{"plains", "tundra", "chaparral", "field", "grassland", "meadow", "prairie", "shrubland", "wasteland", "pasture", "antarctic", "thicket"});
        cGemBiomeSpecMap.put("tourmaline", tourmalineBiomeGenProp.getStringList());
        Property spinelBiomeGenProp = config.get("unique biome generation", "spinelBiomeSpec", new String[]{"jungle", "spikes", "roofed", "bamboo", "grove", "rainforest", "springs", "tropical", "icy hills"});
        cGemBiomeSpecMap.put("spinel", spinelBiomeGenProp.getStringList());
        Property blackOpalBiomeGenProp = config.get("unique biome generation", "blackOpalBiomeSpec", new String[]{"desert", "badlands", "mesa", "outback", "steppe", "xeric", "dunes"});
        cGemBiomeSpecMap.put("blackOpal", blackOpalBiomeGenProp.getStringList());
        Property jasperBiomeGenProp = config.get("unique biome generation", "jasperBiomeSpec", new String[]{"jungle", "spikes", "roofed", "bamboo", "grove", "rainforest", "springs", "tropical", "icy hills"});
        cGemBiomeSpecMap.put("jasper", jasperBiomeGenProp.getStringList());
        Property citrineBiomeGenProp = config.get("unique biome generation", "citrineBiomeSpec", new String[]{"taiga", "coniferous", "redwood", "shield", "temperate", "jade", "spruce"});
        cGemBiomeSpecMap.put("citrine", citrineBiomeGenProp.getStringList());
        Property amberBiomeGenProp = config.get("unique biome generation", "amberBiomeSpec", new String[]{"forest", "wooded", "fen", "orchard", "woodland", "woods"});
        cGemBiomeSpecMap.put("amber", amberBiomeGenProp.getStringList());
        Property jadeBiomeGenProp = config.get("unique biome generation", "jadeBiomeSpec", new String[]{"mountain", "extreme", "alps", "crag", "highland", "moor", "glacier", "volcanic", "badlands", "canyon"});
        cGemBiomeSpecMap.put("jade", jadeBiomeGenProp.getStringList());
        Property malachiteBiomeGenProp = config.get("unique biome generation", "malachiteBiomeSpec", new String[]{"plains", "tundra", "chaparral", "field", "grassland", "meadow", "prairie", "shrubland", "wasteland", "pasture", "antarctic", "thicket"});
        cGemBiomeSpecMap.put("malachite", malachiteBiomeGenProp.getStringList());
        Property turquoiseBiomeGenProp = config.get("unique biome generation", "turquoiseBiomeSpec", new String[]{"desert", "badlands", "mesa", "outback", "steppe", "xeric", "dunes"});
        cGemBiomeSpecMap.put("turquoise", turquoiseBiomeGenProp.getStringList());
        Property sugiliteBiomeGenProp = config.get("unique biome generation", "sugiliteBiomeSpec", new String[]{"ocean", "river", "beach", "lake", "marsh", "kelp", "coral"});
        cGemBiomeSpecMap.put("sugilite", sugiliteBiomeGenProp.getStringList());
        Property roseQuartzBiomeGenProp = config.get("unique biome generation", "roseQuartzBiomeSpec", new String[]{"swamp", "mushroom", "bayou", "bog", "mangrove", "quagmire", "wetlands", "fungi", "silkglades", "sludgepit"});
        cGemBiomeSpecMap.put("roseQuartz", roseQuartzBiomeGenProp.getStringList());
        Property onyxBiomeGenProp = config.get("unique biome generation", "onyxBiomeSpec", new String[]{"savanna", "cliffs", "tropical", "oasis", "origin", "overgrown", "scrubland", "heathland", "brushland"});
        cGemBiomeSpecMap.put("onyx", onyxBiomeGenProp.getStringList());
    }

    static {
        cGemEnabledMap = new HashMap<String, Boolean>();
        cNetherGemEnabledMap = new HashMap<String, Boolean>();
        cGemBiomeSpecMap = new HashMap<String, String[]>();
        isGemsToEmeraldsEnabled = false;
        isVillagerFollowEmeraldBlockEnabled = true;
        isGemInfusedSwordsEnabled = true;
        infusedSwordKillsPerLevel = 10;
        infusedSwordLevelCap = 9;
        isSilverAlloyRecipeEnabled = true;
        instance = new Main();
    }
}

