/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.items.GemSetAxe;
import com.chrisgli.gemsnjewels.items.GemSetSword;
import com.chrisgli.gemsnjewels.items.SolidGemSword;
import com.chrisgli.gemsnjewels.util.Icons;
import com.chrisgli.gemsnjewels.util.RegistryHandler;
import com.chrisgli.gemsnjewels.worldgen.OreGen;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

@Mod(value="gemsnjewels")
public class Main {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "gemsnjewels";
    public static final ItemGroup TAB = new ItemGroup("gemsnjewels_materials"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryHandler.RUBY.get());
        }
    };
    public static final ItemGroup TOOL_TAB = new ItemGroup("gemsnjewels_tools"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryHandler.RUBY_SET_SWORD.get());
        }
    };
    public static final ItemGroup BLOCK_TAB = new ItemGroup("gemsnjewels_blocks"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)RegistryHandler.RUBY_BLOCK.get());
        }
    };

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GemsNJewelsConfig.COMMON_SPEC, "gemsnjewels-common.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
        RegistryHandler.init();
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
        DeferredWorkQueue.runLater(OreGen::generateOre);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        LOGGER.info("Got game settings {}", (Object)((Minecraft)event.getMinecraftSupplier().get()).field_71474_y);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(Icons.INSTANCE::onModelRegister);
        modBus.addListener(Icons.INSTANCE::onModelBake);
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"examplemod", (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
        boolean curiosLoaded = ModList.get().isLoaded("curios");
        if (curiosLoaded) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("ring").setEnabled(true).setHidden(false));
        }
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof VillagerEntity) {
            VillagerEntity entity = (VillagerEntity)event.getEntity();
            Ingredient temptItems = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221739_dF, (IItemProvider)RegistryHandler.EMERALD_BLOCK_ITEM.get()});
            entity.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)entity, 1.0, false, temptItems));
        }
    }

    @SubscribeEvent
    public void expDrop(LivingHurtEvent event) {
        block5: {
            int i;
            GemSetAxe axeItem;
            ItemStack swordType;
            LivingEntity entityTarget;
            block6: {
                int j;
                int i2;
                Entity attacker = event.getSource().func_76346_g();
                Entity target = event.getEntityLiving().getEntity();
                if (!(attacker instanceof LivingEntity) || !(target instanceof LivingEntity) || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) break block5;
                LivingEntity entityAttacker = (LivingEntity)attacker;
                entityTarget = (LivingEntity)target;
                swordType = entityAttacker.func_184614_ca();
                if (!(swordType.func_77973_b() instanceof GemSetSword)) break block6;
                GemSetSword swordItem = (GemSetSword)swordType.func_77973_b();
                if (swordItem.getCurrentLevel(swordType) < 3 || entityTarget.field_70170_p.field_72995_K || (i2 = (int)event.getAmount()) <= 1) break block5;
                if ((float)i2 >= swordItem.getTotalBaseDamage()) {
                    i2 *= 2;
                }
                i2 = (int)((double)i2 / 2.0);
                for (i2 = entityTarget.field_70170_p.field_73012_v.nextInt(i2); i2 > 0; i2 -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i2);
                    entityTarget.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(entityTarget.field_70170_p, entityTarget.func_226277_ct_(), entityTarget.func_226278_cu_() + 1.0, entityTarget.func_226281_cx_(), j));
                }
                break block5;
            }
            if (swordType.func_77973_b() instanceof GemSetAxe && (axeItem = (GemSetAxe)swordType.func_77973_b()).getLevelProgress(swordType) >= 30 && !entityTarget.field_70170_p.field_72995_K && (i = (int)event.getAmount()) > 1) {
                int j;
                if ((float)i >= axeItem.getTotalBaseDamage()) {
                    i *= 2;
                }
                i = (int)((double)i / 2.0);
                for (i = entityTarget.field_70170_p.field_73012_v.nextInt(i); i > 0; i -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i);
                    entityTarget.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(entityTarget.field_70170_p, entityTarget.func_226277_ct_(), entityTarget.func_226278_cu_() + 1.0, entityTarget.func_226281_cx_(), j));
                }
            }
        }
    }

    @SubscribeEvent
    public void livingEntityDeath(LivingDeathEvent event) {
        LivingEntity entityAttacker;
        ItemStack heldItem;
        Entity attacker = event.getSource().func_76346_g();
        if (attacker instanceof LivingEntity && ((heldItem = (entityAttacker = (LivingEntity)attacker).func_184614_ca()).func_77973_b() instanceof GemSetSword || heldItem.func_77973_b() instanceof SolidGemSword)) {
            CompoundNBT nbt = heldItem.func_77942_o() ? heldItem.func_77978_p() : new CompoundNBT();
            if (nbt.func_74764_b("Kills")) {
                nbt.func_74768_a("Kills", nbt.func_74762_e("Kills") + 1);
            } else {
                nbt.func_74768_a("Kills", 1);
            }
            heldItem.func_77982_d(nbt);
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }
    }
}

