/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.compat;

import com.chrisgli.gemsnjewels.items.GemSetRing;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import top.theillusivec4.curios.api.CuriosAPI;
import top.theillusivec4.curios.api.capability.CuriosCapability;
import top.theillusivec4.curios.api.capability.ICurio;
import top.theillusivec4.curios.api.imc.CurioIMCMessage;

public class CuriosCompatability {
    private static final UUID SPEED_UUID = UUID.fromString("8b7c8fcd-89bc-4794-8bb9-eddeb32753a5");
    private static final UUID ARMOR_UUID = UUID.fromString("38faf191-bf78-4654-b349-cc1f4f1143bf");

    public static void sendImc() {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new CurioIMCMessage("ring").setSize(2).setEnabled(true).setHidden(false));
    }

    public static ICapabilityProvider initCapabilities(final ItemStack stack) {
        final ICurio curio = new ICurio(){

            public boolean canRightClickEquip() {
                return false;
            }

            public void onCurioTick(String identifier, int index, LivingEntity livingEntity) {
                if (!livingEntity.func_130014_f_().field_72995_K && livingEntity.field_70173_aa % 19 == 0) {
                    livingEntity.func_195064_c(new EffectInstance(Effects.field_188425_z, 20, 0, true, true));
                }
            }

            public Multimap<String, AttributeModifier> getAttributeModifiers(String identifier) {
                HashMultimap atts = HashMultimap.create();
                if (CuriosAPI.getCurioTags((Item)stack.func_77973_b()).contains(identifier)) {
                    atts.put((Object)SharedMonsterAttributes.field_188792_h.func_111108_a(), (Object)new AttributeModifier("03C3C89D-7037-4B42-869F-B146BCB64D2E", 1.0, AttributeModifier.Operation.ADDITION));
                }
                return atts;
            }

            public void playEquipSound(LivingEntity livingEntity) {
                livingEntity.field_70170_p.func_184133_a(null, livingEntity.func_180425_c(), SoundEvents.field_187722_q, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            }

            public boolean hasRender(String identifier, LivingEntity livingEntity) {
                return true;
            }

            @OnlyIn(value=Dist.CLIENT)
            public void render(String identifer, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Item ring = stack.func_77973_b();
                if (ring instanceof GemSetRing) {
                    ring = (GemSetRing)stack.func_77973_b();
                    EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)livingEntity);
                    if (!(renderer instanceof IEntityRenderer)) {
                        return;
                    }
                    EntityModel model = ((IEntityRenderer)renderer).func_217764_d();
                    if (!(model instanceof BipedModel)) {
                        return;
                    }
                    ((GemSetRing)ring).doRender((BipedModel)model, stack, livingEntity, matrixStack, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
                }
            }
        };
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
    }
}

