/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.Main;
import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GemSetSword
extends SwordItem {
    private final float totalBaseDamage;
    private final float baseAttackSpeed;

    public GemSetSword() {
        super((IItemTier)ItemTier.DIAMOND, 3, -2.4f, new Item.Properties().func_200916_a(Main.TOOL_TAB));
        this.totalBaseDamage = 3.0f + ItemTier.DIAMOND.func_200929_c();
        this.baseAttackSpeed = -2.4f;
    }

    public GemSetSword(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties p_i48460_4_) {
        super(tier, attackDamageIn, attackSpeedIn, p_i48460_4_);
        this.totalBaseDamage = (float)attackDamageIn + tier.func_200929_c();
        this.baseAttackSpeed = attackSpeedIn;
    }

    public float getTotalBaseDamage() {
        return this.totalBaseDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getCurrentLevel(ItemStack stack) {
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Kills")) {
                return nbt.func_74762_e("Kills") / 10;
            }
            return 0;
        }
        return 0;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        CompoundNBT nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("Kills") && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int killCount = nbt.func_74762_e("Kills");
            int randomChance = attacker.field_70170_p.field_73012_v.nextInt(2);
            if (killCount >= 70 && randomChance == 1) {
                return true;
            }
        }
        stack.func_222118_a(1, attacker, p_220045_0_ -> p_220045_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Kills")) {
            int i;
            int killCount = stack.func_77978_p().func_74762_e("Kills");
            String kills = "\u00a7e" + Integer.toString(killCount);
            String level = "Lvl: " + killCount / 10;
            level = killCount / 10 < 5 ? level + " \u00a77Novice" : (killCount / 10 < 10 ? level + " \u00a7aAdept" : (killCount / 10 < 20 ? level + " \u00a79Heroic" : (killCount / 10 < 30 ? level + " \u00a7dMaster" : (killCount / 10 < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            String progression = "|\u00a7a";
            for (i = 0; i < killCount % 10; ++i) {
                progression = progression + "=";
            }
            progression = progression + "\u00a77";
            for (i = killCount % 10; i < 10; ++i) {
                progression = progression + "-";
            }
            progression = progression + "\u00a7f|";
            StringTextComponent slain = new StringTextComponent("Mobs Slain: " + kills);
            StringTextComponent levelText = new StringTextComponent(level);
            StringTextComponent progText = new StringTextComponent(progression);
            tooltip.add((ITextComponent)slain);
            if (KeyboardHelper.isHoldingShift() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)levelText);
                tooltip.add((ITextComponent)progText);
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Gains bonus attack speed per level"));
                if (killCount / 10 >= 3) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Bleeds experience from mobs"));
                }
                if (killCount / 10 >= 7) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for level details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gains perks from slaying mobs"));
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        int kills;
        float attackSpeedBonus;
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
            kills = 0;
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Kills")) {
                kills = stack.func_77978_p().func_74762_e("Kills");
            }
        } else {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        attackSpeedBonus = attackSpeedBonus * (float)(kills / 10) * 10.0f / 100.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getTotalBaseDamage(), AttributeModifier.Operation.ADDITION));
        multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }
}

