/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.chrisgli.gemsnjewels.util.helpers.KeyboardHelper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class GemSetPickaxe
extends PickaxeItem {
    private final float baseAttackSpeed;
    private final float baseAttackDamage;

    public GemSetPickaxe(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.baseAttackSpeed = attackSpeedIn;
        this.baseAttackDamage = (float)attackDamageIn + tier.func_200929_c();
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public float getTotalBaseDamage() {
        return this.baseAttackDamage;
    }

    public int getLevelProgress(ItemStack stack) {
        int oreCount = 0;
        int blockCount = 0;
        if (stack.func_77942_o()) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_74764_b("Ores")) {
                oreCount = nbt.func_74762_e("Ores");
            }
            if (nbt.func_74764_b("Blocks")) {
                blockCount = nbt.func_74762_e("Blocks");
            }
        }
        return oreCount + blockCount / 2;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean isNamedOre;
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        String displayName = new ItemStack((IItemProvider)worldIn.func_180495_p(pos).func_177230_c()).func_200301_q().getString();
        boolean bl = isNamedOre = displayName.equals("ore") || displayName.length() > 3 && (displayName.toLowerCase().substring(displayName.length() - 4).equals(" ore") || displayName.toLowerCase().contains(" ore "));
        if (isNamedOre) {
            if (nbt.func_74764_b("Ores")) {
                nbt.func_74768_a("Ores", nbt.func_74762_e("Ores") + 1);
            } else {
                nbt.func_74768_a("Ores", 1);
            }
            stack.func_77982_d(nbt);
        } else {
            if (nbt.func_74764_b("Blocks")) {
                nbt.func_74768_a("Blocks", nbt.func_74762_e("Blocks") + 1);
            } else {
                nbt.func_74768_a("Blocks", 1);
            }
            stack.func_77982_d(nbt);
        }
        if (stack.func_77942_o() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            int levelProgress = this.getLevelProgress(stack);
            int randomChance = entityLiving.field_70170_p.field_73012_v.nextInt(2);
            if (levelProgress >= 70 && randomChance == 1) {
                return true;
            }
            if (levelProgress >= 30 && !entityLiving.field_70170_p.field_72995_K) {
                int j;
                for (int i = entityLiving.field_70170_p.field_73012_v.nextInt(2) + entityLiving.field_70170_p.field_73012_v.nextInt(2); i > 0; i -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i);
                    entityLiving.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(entityLiving.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), j));
                }
            }
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlotType.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int lvl = this.getLevelProgress(stack);
        attackSpeedBonus = attackSpeedBonus * (float)(lvl / 10) * 10.0f / 100.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.baseAttackDamage, AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Ores") || stack.func_77978_p().func_74764_b("Blocks")) {
            int i;
            int oreCount = stack.func_77978_p().func_74762_e("Ores");
            String ores = "\u00a7e" + Integer.toString(oreCount);
            StringTextComponent mined = new StringTextComponent("Ores Mined: " + ores);
            tooltip.add((ITextComponent)mined);
            int lvlProgress = this.getLevelProgress(stack);
            int lvl = lvlProgress / 10;
            String level = "Lvl: " + lvl;
            level = lvl < 5 ? level + " \u00a77Novice" : (lvl < 10 ? level + " \u00a7aAdept" : (lvl < 20 ? level + " \u00a7bHeroic" : (lvl < 30 ? level + " \u00a7dMaster" : (lvl < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            String progression = "|\u00a7a";
            for (i = 0; i < lvlProgress % 10; ++i) {
                progression = progression + "=";
            }
            progression = progression + "\u00a77";
            for (i = lvlProgress % 10; i < 10; ++i) {
                progression = progression + "-";
            }
            progression = progression + "\u00a7f|";
            StringTextComponent levelText = new StringTextComponent(level);
            StringTextComponent progText = new StringTextComponent(progression);
            if (KeyboardHelper.isHoldingShift() && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)levelText);
                tooltip.add((ITextComponent)progText);
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Gains bonus swing speed per level"));
                if (lvl >= 3) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Mining blocks grants experience"));
                }
                if (lvl >= 7) {
                    tooltip.add((ITextComponent)new StringTextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((ITextComponent)new StringTextComponent("\u00a75Hold [Shift] for level details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((ITextComponent)new StringTextComponent("\u00a77Gains perks from mining blocks"));
        }
    }
}

