/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki;

import com.mojang.brigadier.CommandDispatcher;
import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.StatsCommand;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.handlers.TickHandler;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.minecraft.command.CommandSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="gokistats")
public class GokiStats {
    public static GokiStats instance;
    public static final Logger log;
    private static final Class<?>[] loadClasses;

    public GokiStats() {
        instance = this;
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::construct);
        eventBus.addListener(this::registerCommands);
        GokiPacketHandler.registerMessages();
    }

    public void construct(FMLCommonSetupEvent event) {
        try {
            for (Class<?> clz : loadClasses) {
                Class.forName(clz.getName());
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("Cannot load classes, this may cause some issues", (Throwable)e);
        }
        CapabilityStat.register();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)new TickHandler());
        this.initConfig();
        if (ModList.get().isLoaded("additionalevents")) {
            Stats.TREASURE_FINDER.setEnabled(true);
            Stats.MINING_MAGICIAN.setEnabled(true);
        }
    }

    public void registerCommands(FMLServerStartingEvent event) {
        StatsCommand.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    public void initConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, GokiConfig.serverSpec);
    }

    static {
        log = LogManager.getLogger((String)"gokistats");
        loadClasses = new Class[]{Stats.class};
    }
}

