/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.client.gui.GuiExtendedButton;
import net.infstudio.goki.common.stat.tool.ToolSpecificStat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiCompatibilityHelper
extends Screen {
    private static final int BUTTON_WIDTH = 240;
    private static final int BUTTON_HEIGHT = 15;
    private final ToolSpecificStat[] compatibleStats = new ToolSpecificStat[]{Stats.MINING, Stats.DIGGING, Stats.CHOPPING, Stats.TRIMMING, Stats.SWORDSMANSHIP, Stats.BOWMANSHIP};
    private final PlayerEntity player;

    public GuiCompatibilityHelper() {
        super((ITextComponent)new StringTextComponent(""));
        this.player = this.minecraft.field_71439_g;
        this.minecraft = Minecraft.func_71410_x();
    }

    public void init() {
        int x = this.width / 2;
        int y = this.height / 2 - 45;
        this.buttons.add(new GuiExtendedButton(0, x - 120, y - 15, 240, 15, "Add item to Mining list", 0x333333, this::actionPerformed));
        this.buttons.add(new GuiExtendedButton(1, x - 120, y - 15 + 15, 240, 15, "Add item to Digging list", 0x333333, this::actionPerformed));
        this.buttons.add(new GuiExtendedButton(2, x - 120, y - 15 + 30, 240, 15, "Add item to Chopping list", 0x333333, this::actionPerformed));
        this.buttons.add(new GuiExtendedButton(3, x - 120, y - 15 + 45, 240, 15, "Add item to Trimming list", 0x333333, this::actionPerformed));
        this.buttons.add(new GuiExtendedButton(4, x - 120, y - 15 + 60, 240, 15, "Add item to Swordsmanship list", 0x333333, this::actionPerformed));
        this.buttons.add(new GuiExtendedButton(5, x - 120, y - 15 + 75, 240, 15, "Add item to Bowmanship list", 0x333333, this::actionPerformed));
        this.checkStatus();
    }

    public void render(int par1, int par2, float par3) {
        super.render(par1, par2, par3);
        this.drawCenteredString(this.minecraft.field_71466_p, "This is CLIENT-SIDE. Copy the config to the server and /reloadGokiStats.", this.width / 2, 16, 0xFFFFFF);
    }

    protected void actionPerformed(Button btn) {
        if (!(btn instanceof GuiExtendedButton)) {
            return;
        }
        GuiExtendedButton button = (GuiExtendedButton)btn;
        if (this.compatibleStats[button.id].isEffectiveOn(this.player.func_184614_ca())) {
            this.compatibleStats[button.id].removeSupportForItem(this.player.func_184614_ca());
        } else {
            this.compatibleStats[button.id].addSupportForItem(this.player.func_184614_ca());
        }
        this.checkStatus();
    }

    public void checkStatus() {
        for (int i = 0; i < this.compatibleStats.length; ++i) {
            if (this.compatibleStats[i].isEffectiveOn(this.player.func_184614_ca())) {
                ((Widget)this.buttons.get(i)).setMessage("Remove item from " + this.compatibleStats[i].getLocalizedName() + " list.");
                ((GuiExtendedButton)((Object)this.buttons.get(i))).setBackgroundColor(0x339933);
                continue;
            }
            ((Widget)this.buttons.get(i)).setMessage("Add item to " + this.compatibleStats[i].getLocalizedName() + " list.");
            ((GuiExtendedButton)((Object)this.buttons.get(i))).setBackgroundColor(0x993333);
        }
    }

    public void onClose() {
    }
}

