/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import org.lwjgl.opengl.GL11;

public class GuiExtendedButton
extends Button {
    public static final int BORDER_COLOR = -16777216;
    private int backgroundColor;
    private boolean pressed = false;
    public boolean disabled = false;
    public final int id;

    public GuiExtendedButton(int id, int x, int y, int width, int height, String text, int color, Button.IPressable onPress) {
        super(x, y, width, height, text, onPress);
        this.id = id;
        this.backgroundColor = color;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (!this.disabled) {
            if (!this.isUnderMouse(mouseX, mouseY)) {
                this.drawIdle(Minecraft.func_71410_x(), mouseX, mouseY);
            } else if (this.pressed) {
                this.drawDown(Minecraft.func_71410_x(), mouseX, mouseY);
            } else {
                this.drawHover(Minecraft.func_71410_x(), mouseX, mouseY);
            }
        } else {
            this.drawDisabled(Minecraft.func_71410_x(), mouseX, mouseY);
        }
    }

    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
    }

    private void drawBorder() {
        this.hLine(-1, this.width, 0, -16777216);
        this.hLine(-1, this.width, this.height, -16777216);
        this.vLine(-1, 0, this.height, -16777216);
        this.vLine(this.width, 0, this.height, -16777216);
    }

    private void drawDisabled(Minecraft mc, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GuiExtendedButton.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)-2011028958);
        FontRenderer fontRenderer = mc.field_71466_p;
        String string = this.getMessage();
        int n = this.width / 2;
        int n2 = this.height / 2;
        mc.field_71466_p.getClass();
        this.drawCenteredString(fontRenderer, string, n, n2 - 9 / 2 + 1, 0x333333);
        this.drawBorder();
        GL11.glPopMatrix();
    }

    private void drawIdle(Minecraft mc, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GuiExtendedButton.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)(this.backgroundColor + -2013265920));
        FontRenderer fontRenderer = mc.field_71466_p;
        String string = this.getMessage();
        int n = this.width / 2;
        int n2 = this.height / 2;
        mc.field_71466_p.getClass();
        this.drawCenteredString(fontRenderer, string, n, n2 - 9 / 2 + 1, 0xFFFFFF);
        this.drawBorder();
        GL11.glPopMatrix();
    }

    private void drawHover(Minecraft mc, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GuiExtendedButton.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)(this.backgroundColor + -16777216));
        FontRenderer fontRenderer = mc.field_71466_p;
        String string = this.getMessage();
        int n = this.width / 2;
        int n2 = this.height / 2;
        mc.field_71466_p.getClass();
        this.drawCenteredString(fontRenderer, string, n, n2 - 9 / 2 + 1, 0xFFCC00);
        this.drawBorder();
        GL11.glPopMatrix();
    }

    private void drawDown(Minecraft mc, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        GuiExtendedButton.fill((int)0, (int)0, (int)this.width, (int)this.height, (int)-16777216);
        FontRenderer fontRenderer = mc.field_71466_p;
        String string = this.getMessage();
        int n = this.width / 2;
        int n2 = this.height / 2;
        mc.field_71466_p.getClass();
        this.drawCenteredString(fontRenderer, string, n, n2 - 9 / 2 + 1, 0xFFCC00);
        this.drawBorder();
        GL11.glPopMatrix();
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.active && this.visible) {
            if (keyCode != 257 && keyCode != 32 && keyCode != 335) {
                return false;
            }
            this.onRelease();
            return true;
        }
        return false;
    }

    public void onPress() {
        super.onPress();
        this.pressed = true;
    }

    public void onRelease() {
        this.pressed = false;
    }

    public boolean isPressed() {
        return this.pressed;
    }
}

