/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.client.gui.GuiStats;
import net.infstudio.goki.common.utils.DataHelper;
import net.infstudio.goki.common.utils.Reference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import org.lwjgl.opengl.GL11;

public class GuiStatButton
extends Button {
    public StatBase stat;
    public PlayerEntity player;
    public static final int INACTIVE_X = 0;
    public static final int ACTIVATED_X = 24;
    public static final int DISABLED_X = 48;
    public static final int MAXIMUM_X = 72;
    public final int id;
    private final Minecraft mc = Minecraft.func_71410_x();

    public GuiStatButton(int id, int x, int y, int width, int height, StatBase stat, PlayerEntity player, Button.IPressable onPress) {
        super(x, y, width, height, "", onPress);
        this.id = id;
        this.stat = stat;
        this.player = player;
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            int iconY = 24 * (this.stat.imageID % 10);
            int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
            int cost = this.stat.getCost(level);
            int playerXP = DataHelper.getXPTotal(this.player);
            FontRenderer fontrenderer = this.mc.field_71466_p;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = this.isUnderMouse(mouseX, mouseY);
            int iconX = 0;
            if (this.isHovered()) {
                iconX = 24;
            }
            if (playerXP < cost) {
                iconX = 0;
            }
            if (level >= this.stat.getLimit()) {
                iconX = 72;
            }
            if (Screen.hasControlDown()) {
                iconX = DataHelper.canPlayerRevertStat(this.player, this.stat) ? 24 : 48;
            }
            if (!this.stat.isEnabled()) {
                iconX = 48;
            }
            String message = level + "";
            if (!this.stat.isEnabled()) {
                iconX = 48;
                message = "X";
            }
            int messageColor = 0xFFFFFF;
            if (level >= this.stat.getLimit()) {
                message = "*" + level + "*";
                messageColor = 0xFFCC00;
            }
            iconX += this.stat.imageID % 20 / 10 * 24 * 4;
            if (this.stat.imageID >= 20) {
                this.mc.func_110434_K().func_110577_a(Reference.RPG_ICON_2_TEXTURE_LOCATION);
            } else {
                this.mc.func_110434_K().func_110577_a(Reference.RPG_ICON_TEXTURE_LOCATION);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
            GL11.glScalef((float)GuiStats.SCALE, (float)GuiStats.SCALE, (float)0.0f);
            this.blit(0, 0, iconX, iconY, this.width, this.height);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
            this.drawCenteredString(fontrenderer, message, (int)((float)(this.width / 2) * GuiStats.SCALE), (int)((float)this.height * GuiStats.SCALE) + 2, messageColor);
            GL11.glPopMatrix();
        }
    }

    public boolean isUnderMouse(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseY >= this.y && (float)mouseX < (float)this.x + (float)this.width * GuiStats.SCALE && (float)mouseY < (float)this.y + (float)this.height * GuiStats.SCALE;
    }

    public void onClick(double p_onClick_1_, double p_onClick_3_) {
        super.onClick(p_onClick_1_, p_onClick_3_);
    }

    public boolean mousePressed(Minecraft par1Minecraft, int mouseX, int mouseY) {
        return this.active && this.visible && mouseX >= this.x && mouseY >= this.y && (float)mouseX < (float)this.x + (float)this.width * GuiStats.SCALE && (float)mouseY < (float)this.y + (float)this.height * GuiStats.SCALE;
    }

    public String getHoverMessage(int which) {
        if (which == 0) {
            return this.stat.getLocalizedName() + " L" + DataHelper.getPlayerStatLevel(this.player, this.stat);
        }
        return this.stat.getLocalizedDescription(this.player);
    }
}

