/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.client.gui;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;

public class GuiStatTooltip
extends AbstractGui {
    private StatBase stat;
    private PlayerEntity player;
    private int padding = 4;
    private final Minecraft mc = Minecraft.func_71410_x();

    public GuiStatTooltip(StatBase stat, PlayerEntity player) {
        this.stat = stat;
        this.player = player;
    }

    public void draw(int drawX, int drawY, int mouseButton) {
        int rightEdge;
        int right;
        int revertLevel;
        LinkedHashMap<String, Integer> messageColorMap = new LinkedHashMap<String, Integer>();
        AtomicInteger widthAtomic = new AtomicInteger();
        AtomicInteger heightAtomic = new AtomicInteger();
        int level = DataHelper.getPlayerStatLevel(this.player, this.stat);
        messageColorMap.put(this.stat.getLocalizedName() + " L" + level, -13312);
        messageColorMap.put(this.stat.getLocalizedDescription(this.player), -1);
        if (level >= this.stat.getLimit()) {
            messageColorMap.put(I18n.func_135052_a((String)"ui.max", (Object[])new Object[0]), -16724737);
        } else {
            messageColorMap.put(I18n.func_135052_a((String)"ui.cost", (Object[])new Object[]{this.stat.getCost(level)}), -16724737);
        }
        if (Screen.hasControlDown()) {
            messageColorMap.put(I18n.func_135052_a((String)"ui.return", (Object[])new Object[]{(double)this.stat.getCost(level) * (Double)GokiConfig.SERVER.globalRevertFactor.get()}), -16724737);
        }
        if ((revertLevel = DataHelper.getPlayerRevertStatLevel(this.player, this.stat)) > 0) {
            if ((Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() != -1) {
                messageColorMap.put(I18n.func_135052_a((String)"ui.reverted", (Object[])new Object[]{revertLevel, String.valueOf(GokiConfig.SERVER.globalMaxRevertLevel.get())}), -16724737);
            } else {
                messageColorMap.put(I18n.func_135052_a((String)"ui.reverted", (Object[])new Object[]{revertLevel, I18n.func_135052_a((String)"ui.infinite", (Object[])new Object[0])}), -16724737);
            }
        }
        if (Screen.hasControlDown()) {
            if (DataHelper.canPlayerRevertStat(this.player, this.stat)) {
                messageColorMap.put(I18n.func_135052_a((String)"ui.revert", (Object[])new Object[0]), -16488449);
            } else {
                messageColorMap.put(I18n.func_135052_a((String)"ui.norevert", (Object[])new Object[0]), -321024);
            }
        } else {
            messageColorMap.put(I18n.func_135052_a((String)"ui.hover", (Object[])new Object[0]), -16488449);
        }
        messageColorMap.forEach((text, color) -> {
            widthAtomic.set(Math.max(widthAtomic.get(), this.mc.field_71466_p.func_78256_a(text)));
            this.mc.field_71466_p.getClass();
            heightAtomic.addAndGet(9);
        });
        int width = widthAtomic.get() + this.padding * 2;
        int height = heightAtomic.get() + this.padding * 2;
        int h = height / messageColorMap.size();
        int x = drawX - width / 2;
        int leftEdge = 0;
        int left = x;
        if (left < leftEdge) {
            x -= leftEdge - left + 1;
        }
        if ((right = x + width) > (rightEdge = this.mc.field_71462_r.width)) {
            x += rightEdge - right - 1;
        }
        GuiStatTooltip.fill((int)x, (int)drawY, (int)(x + width), (int)(drawY - height), (int)-872415232);
        for (int i = messageColorMap.size(); i >= 1; --i) {
            Map.Entry entry = messageColorMap.entrySet().toArray(new Map.Entry[0])[messageColorMap.size() - i];
            this.drawString(this.mc.field_71466_p, (String)entry.getKey(), x + this.padding / 2, drawY - h * i + this.padding / 2, (Integer)entry.getValue());
        }
        this.drawBorder(x, drawY, width, height, -1);
    }

    private void drawBorder(int x, int y, int width, int height, int borderColor) {
        this.hLine(x - 1, x + width, y, borderColor);
        this.hLine(x - 1, x + width, y - height, borderColor);
        this.vLine(x - 1, y, y - height, borderColor);
        this.vLine(x + width, y, y - height, borderColor);
    }
}

