/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import com.tfar.additionalevents.event.DropLootEvent;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Random;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.init.GokiSounds;
import net.infstudio.goki.common.stat.tool.StatMiningMagician;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="gokistats")
@Mod.EventBusSubscriber(modid="gokistats")
public class AdditionalEventHandler {
    @SubscribeEvent
    public static void harvestBlock(DropLootEvent event) {
        PlayerEntity player = event.getPlayer();
        Block block = event.getState().func_177230_c();
        if (player == null) {
            return;
        }
        if (DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER) > 0) {
            boolean treasureFound = false;
            Random random = player.func_70681_au();
            List<ItemStack> items = Stats.TREASURE_FINDER.getApplicableItemStackList(block, DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER));
            IntList chances = Stats.TREASURE_FINDER.getApplicableChanceList(block, DataHelper.getPlayerStatLevel(player, Stats.TREASURE_FINDER));
            for (int i = 0; i < items.size(); ++i) {
                int roll = random.nextInt(10000);
                if (roll > chances.getInt(i)) continue;
                if (items.get(i) != null) {
                    event.getDrops().add(items.get(i));
                    treasureFound = true;
                    continue;
                }
                System.out.println("Tried to add an item from Treasure Finder, but it failed!");
            }
            if (treasureFound) {
                player.field_70170_p.func_184133_a(player, event.getPos(), GokiSounds.TREASURE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
        if (DataHelper.getPlayerStatLevel(player, Stats.MINING_MAGICIAN) > 0) {
            boolean magicHappened = false;
            if (Stats.MINING_MAGICIAN.isEffectiveOn(block)) {
                block1: for (int i = 0; i < event.getDrops().size(); ++i) {
                    if (!(player.func_70681_au().nextDouble() * 100.0 <= (double)Stats.MINING_MAGICIAN.getBonus(player))) continue;
                    ItemStack item = event.getDrops().get(i);
                    if (item.func_77973_b() instanceof BlockItem && item.func_77973_b().getRegistryName().equals((Object)block.getRegistryName())) {
                        int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.blockEntries.size());
                        ItemStack stack = new ItemStack((IItemProvider)StatMiningMagician.blockEntries.get(randomEntry), 1);
                        stack.func_190920_e(event.getDrops().get(i).func_190916_E());
                        event.getDrops().add(stack);
                        magicHappened = true;
                        continue;
                    }
                    for (int j = 0; j < StatMiningMagician.itemEntries.size(); ++j) {
                        if (item.func_77973_b() != StatMiningMagician.itemEntries.get(j)) continue;
                        int randomEntry = player.func_70681_au().nextInt(StatMiningMagician.itemEntries.size());
                        ItemStack stack = new ItemStack((IItemProvider)StatMiningMagician.itemEntries.get(randomEntry), 1);
                        stack.func_190920_e(event.getDrops().get(i).func_190916_E());
                        event.getDrops().add(stack);
                        magicHappened = true;
                        continue block1;
                    }
                }
                if (magicHappened) {
                    player.field_70170_p.func_184133_a(player, event.getPos(), GokiSounds.MAGICIAN, SoundCategory.BLOCKS, 0.3f, 1.0f);
                }
            }
        }
    }
}

