/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.handlers;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.infstudio.goki.api.stat.Stats;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.handlers.SyncEventHandler;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="gokistats")
public class TickHandler {
    public static final UUID knockbackResistanceID = UUID.randomUUID();
    public static final UUID stealthSpeedID = UUID.randomUUID();
    public static final UUID swimSpeedID = UUID.randomUUID();
    public static AtomicInteger tickTimer = new AtomicInteger();

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            PlayerEntity player = event.player;
            TickHandler.handleTaskPlayerAPI(player);
            IAttributeInstance atinst = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            AttributeModifier mod = new AttributeModifier(stealthSpeedID, "SneakSpeed", (double)(Stats.STEALTH.getBonus(player) / 100.0f), AttributeModifier.Operation.func_220372_a((int)1));
            if (player.func_225608_bj_()) {
                if (atinst.func_111127_a(stealthSpeedID) == null) {
                    atinst.func_111121_a(mod);
                }
            } else if (atinst.func_111127_a(stealthSpeedID) != null) {
                atinst.func_111124_b(mod);
            }
            atinst = player.func_110148_a(SharedMonsterAttributes.field_111266_c);
            mod = new AttributeModifier(knockbackResistanceID, "KnockbackResistance", (double)Stats.STEADY_GUARD.getBonus(player), AttributeModifier.Operation.func_220372_a((int)0));
            if (player.func_184585_cz()) {
                if (atinst.func_111127_a(knockbackResistanceID) == null) {
                    atinst.func_111121_a(mod);
                }
            } else if (atinst.func_111127_a(knockbackResistanceID) != null) {
                atinst.func_111124_b(mod);
            }
            TickHandler.handleFurnace(player);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && (Integer)GokiConfig.SERVER.syncTicks.get() > 0) {
            if (tickTimer.get() == ((Integer)GokiConfig.SERVER.syncTicks.get()).intValue()) {
                tickTimer.lazySet(0);
                for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                    SyncEventHandler.syncPlayerData((PlayerEntity)player);
                }
            } else {
                tickTimer.getAndIncrement();
            }
        }
    }

    public static boolean isJumping(LivingEntity livingBase) {
        return (Boolean)ObfuscationReflectionHelper.getPrivateValue(LivingEntity.class, (Object)livingBase, (String)"field_70703_bu");
    }

    private static void handleTaskPlayerAPI(PlayerEntity player) {
        float multiplier;
        if ((player.func_70613_aW() || player.func_184186_bw()) && player.func_203007_ba()) {
            multiplier = Math.max(0.0f, Stats.SWIMMING.getBonus(player));
            if (TickHandler.isJumping((LivingEntity)player)) {
                player.field_70747_aH += multiplier;
            } else if (multiplier > 0.0f) {
                double d0 = player.func_226278_cu_();
                float f1 = 0.8f;
                float f2 = 0.02f;
                if (multiplier > 0.0f) {
                    f1 += (0.54600006f - f1) * multiplier;
                    f2 += (player.func_70689_ay() - f2) * multiplier;
                }
                player.func_213309_a(f2, new Vec3d((double)player.field_70702_br, (double)player.field_70701_bs, (double)player.field_191988_bg));
                player.func_213315_a(MoverType.SELF, player.func_213322_ci());
                player.func_213317_d(player.func_213322_ci().func_216372_d((double)f1, (double)0.8f, (double)f1));
                if (!player.func_189652_ae()) {
                    player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, 0.02, 0.0));
                }
                Vec3d offset = player.func_213322_ci().func_72441_c(0.0, (double)0.6f - player.func_226278_cu_() + d0, 0.0);
                if (player.field_70123_F && player.func_70038_c(offset.field_72450_a, offset.field_72448_b, offset.field_72449_c)) {
                    player.func_213317_d(new Vec3d(player.func_213322_ci().field_72450_a, (double)0.3f, player.func_213322_ci().field_72449_c));
                }
                player.func_213315_a(MoverType.SELF, new Vec3d((double)(player.field_70702_br * multiplier), (double)(player.field_70701_bs * multiplier), (double)0.02f));
            }
        }
        if (player.func_70617_f_() && !player.func_225608_bj_()) {
            multiplier = Stats.CLIMBING.getBonus(player);
            player.func_213315_a(MoverType.SELF, player.func_213322_ci().func_216372_d(1.0, (double)multiplier, 1.0));
        }
    }

    private static void handleFurnace(PlayerEntity player) {
        if (DataHelper.getPlayerStatLevel(player, Stats.FURNACE_FINESSE) > 0) {
            // empty if block
        }
    }
}

