/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.network.handler;

import java.util.function.Supplier;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.network.GokiPacketHandler;
import net.infstudio.goki.common.network.message.C2SRequestStatSync;
import net.infstudio.goki.common.network.message.C2SStatSync;
import net.infstudio.goki.common.network.message.S2CStatSync;
import net.infstudio.goki.common.network.message.S2CSyncAll;
import net.infstudio.goki.common.stat.StatMaxHealth;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class PacketSyncHandler {
    public static void acceptC2S(C2SStatSync message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ServerPlayerEntity player = ctx.getSender();
        StatBase stat = (StatBase)StatBase.stats.get(message.stat);
        if (!stat.isEnabled()) {
            return;
        }
        int reverted = DataHelper.getPlayerRevertStatLevel((PlayerEntity)player, stat);
        if ((Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() < reverted - message.amount && (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() != -1) {
            return;
        }
        int level = DataHelper.getPlayerStatLevel((PlayerEntity)player, stat);
        if (message.amount < 0 && level == 0) {
            return;
        }
        if (level + message.amount > stat.getLimit()) {
            return;
        }
        int cost = stat.getCost(level + message.amount - 1);
        int currentXP = DataHelper.getXPTotal((PlayerEntity)player);
        ctx.enqueueWork(() -> {
            if (message.amount <= 0) {
                DataHelper.setPlayerRevertStatLevel((PlayerEntity)player, stat, reverted);
                player.func_195068_e((int)((double)stat.getCost(level + message.amount) * (Double)GokiConfig.SERVER.globalRevertFactor.get()));
                if (stat instanceof StatMaxHealth) {
                    player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20.0f + stat.getBonus(level) + (float)message.amount));
                }
                DataHelper.setPlayerStatLevel((PlayerEntity)player, stat, level + message.amount);
                GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CStatSync(StatBase.stats.indexOf((Object)stat), level + message.amount, reverted));
            } else if (currentXP >= cost) {
                if (stat instanceof StatMaxHealth) {
                    player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(20.0f + stat.getBonus(level) + (float)message.amount));
                }
                if (message.amount <= 0) {
                    player.func_195068_e((int)((double)stat.getCost(level + message.amount + 1) * (Double)GokiConfig.SERVER.globalRevertFactor.get()));
                } else {
                    player.func_195068_e(-cost);
                    DataHelper.setPlayerStatLevel((PlayerEntity)player, stat, level + message.amount);
                }
                GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CStatSync(StatBase.stats.indexOf((Object)stat), level + message.amount, reverted));
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void onRequestSyncAll(C2SRequestStatSync message, Supplier<NetworkEvent.Context> ctx) {
        GokiPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> ((NetworkEvent.Context)ctx.get()).getSender()), (Object)new S2CSyncAll((PlayerEntity)ctx.get().getSender()));
        ctx.get().setPacketHandled(true);
    }
}

