/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.entity.player.PlayerEntity;

public class StatMaxHealth
extends StatBase {
    public StatMaxHealth(int id, String key, int limit) {
        super(id, key, limit);
    }

    @Override
    public float getBonus(int level) {
        return StatMaxHealth.getFinalBonus(level);
    }

    @Override
    public int getLimit() {
        if ((Double)GokiConfig.SERVER.globalLimitMultiplier.get() >= 1.0) {
            return 40;
        }
        return (int)((double)(40.0f * this.limitMultiplier) * (Double)GokiConfig.SERVER.globalLimitMultiplier.get());
    }

    @Override
    public int getCost(int level) {
        return (int)((Math.pow(level, 2.0) + 12.0 + (double)level) * (Double)GokiConfig.SERVER.globalCostMultiplier.get());
    }

    @Override
    public float[] getDescriptionFormatArguments(PlayerEntity player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(this.getPlayerStatLevel(player)), 0)};
    }
}

