/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.GokiConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class StatReaper
extends StatBase {
    public StatReaper(int id, String key, int limit) {
        super(id, key, limit);
    }

    @Override
    public float getBonus(int level) {
        return StatReaper.getFinalBonus((float)Math.pow(level, 1.0768) * 0.0025f);
    }

    @Override
    public float[] getDescriptionFormatArguments(PlayerEntity player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(this.getPlayerStatLevel(player)) * 100.0f, 1), ((Integer)GokiConfig.SERVER.reaperLimit.get()).intValue()};
    }

    @Override
    public String getLocalizedDescription(PlayerEntity player) {
        return I18n.func_135052_a((String)("skill.gokistats." + this.key + ".text"), (Object[])new Object[]{Float.valueOf(this.getDescriptionFormatArguments(player)[0]), Float.valueOf(this.getDescriptionFormatArguments(player)[1])});
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] != null && !(obj[0] instanceof PlayerEntity) && obj[0] instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)obj[0];
            int limit = (Integer)GokiConfig.SERVER.reaperLimit.get();
            return target.func_110138_aP() <= (float)limit || limit == -1;
        }
        return false;
    }
}

