/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.stats.TreasureFinderConfig;
import net.infstudio.goki.common.stat.tool.TreasureFinderEntry;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;

public class StatTreasureFinder
extends StatBase<TreasureFinderConfig> {
    public static List<TreasureFinderEntry> entries = new ArrayList<TreasureFinderEntry>();
    public static TreasureFinderEntry[] defaultEntries = new TreasureFinderEntry[]{new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151074_bl, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151078_bh, 1, 40), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151103_aS, 1, 20), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151070_bp, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151016_H, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151123_aH, 1, 10), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151069_bo, 1, 10), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151113_aN, 1, 5), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151111_aL, 1, 5), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151119_aD, 1, 20), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151054_z, 1, 6), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151174_bG, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151172_bF, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151034_e, 1, 10), new TreasureFinderEntry(Blocks.field_196642_W, Items.field_151034_e, 1, 10), new TreasureFinderEntry(Blocks.field_196574_ab, Items.field_151034_e, 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Item.func_150898_a((Block)Blocks.field_150337_Q), 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Item.func_150898_a((Block)Blocks.field_150338_P), 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Item.func_150898_a((Block)Blocks.field_196606_bd), 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Item.func_150898_a((Block)Blocks.field_196605_bc), 1, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151055_y, 1, 100), new TreasureFinderEntry(Blocks.field_196804_gh, Items.field_151080_bb, 1, 30), new TreasureFinderEntry(Blocks.field_196804_gh, Items.field_151081_bc, 1, 30), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151082_bd, 2, 50), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151147_al, 2, 50), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151076_bf, 2, 50), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151042_j, 2, 10), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151043_k, 2, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151116_aA, 2, 10), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151008_G, 2, 10), new TreasureFinderEntry(Blocks.field_150346_d, Item.func_150898_a((Block)Blocks.field_196556_aL), 2, 10), new TreasureFinderEntry(Blocks.field_150354_m, Items.field_151137_ax, 2, 50), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_151133_ar, 3, 20), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196189_ec, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196156_dS, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196160_dU, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196158_dT, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196162_dV, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196164_dW, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196166_dX, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196168_dY, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196170_dZ, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196187_ea, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196190_ed, 3, 2), new TreasureFinderEntry(Blocks.field_150346_d, Items.field_196188_eb, 3, 2)};

    public StatTreasureFinder(int id, String key, int limit) {
        super(id, key, limit);
        Collections.addAll(entries, defaultEntries);
        this.setEnabled(false);
    }

    @Override
    public String getLocalizedDescription(PlayerEntity player) {
        if (this.getPlayerStatLevel(player) == 0) {
            return I18n.func_135052_a((String)("skill.gokistats." + this.key + ".text"), (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)("skill.gokistats." + this.key + ".upgrade"), (Object[])new Object[0]);
    }

    public List<ItemStack> getApplicableItemStackList(Block block, int level) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (TreasureFinderEntry tfe : entries) {
            if (tfe.minimumLevel > level || (tfe.getBlock() != null || block != Blocks.field_150346_d && block != Blocks.field_150349_c) && tfe.getBlock() != block) continue;
            items.add(new ItemStack((IItemProvider)tfe.getItem()));
        }
        return items;
    }

    public IntList getApplicableChanceList(Block block, int level) {
        IntArrayList chance = new IntArrayList();
        for (TreasureFinderEntry tfe : entries) {
            if (tfe.minimumLevel > level || (tfe.getBlock() != null || block != Blocks.field_150346_d && block != Blocks.field_150349_c) && tfe.getBlock() != block) continue;
            chance.add(tfe.chance);
        }
        return chance;
    }

    @Override
    public int getCost(int level) {
        int cost = 170;
        if (level == 1) {
            cost = 370;
        } else if (level == 2) {
            cost = 820;
        }
        return cost;
    }

    @Override
    public int getLimit() {
        return 3;
    }

    @Override
    public float getBonus(int level) {
        return 0.0f;
    }
}

