/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.stats.MiningMagicianConfig;
import net.infstudio.goki.common.utils.DataHelper;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class StatMiningMagician
extends StatBase<MiningMagicianConfig> {
    public static List<Block> blockEntries = new ArrayList<Block>();
    public static List<Item> itemEntries = new ArrayList<Item>();
    private static final List<Block> defaultBlockEntries = Arrays.asList(Blocks.field_150365_q, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150352_o, Blocks.field_150366_p, Blocks.field_150369_x, Blocks.field_196766_fg, Blocks.field_150450_ax);
    private static final List<Item> defaultItemEntries = Arrays.asList(Items.field_151044_h, Items.field_151045_i, Items.field_151166_bC, Items.field_151043_k, Items.field_151042_j, Items.field_222069_lA, Items.field_151128_bU, Items.field_151137_ax);

    public StatMiningMagician(int id, String key, int limit) {
        super(id, key, limit);
        blockEntries.addAll(defaultBlockEntries);
        itemEntries.addAll(defaultItemEntries);
        this.setEnabled(false);
    }

    @Override
    public float getBonus(int level) {
        return StatMiningMagician.getFinalBonus((float)level * 0.3f);
    }

    @Override
    public float[] getDescriptionFormatArguments(PlayerEntity player) {
        return new float[]{DataHelper.trimDecimals(this.getBonus(player), 1)};
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] instanceof Item) {
            return itemEntries.contains(obj[0]);
        }
        if (obj[0] instanceof Block) {
            return blockEntries.contains(obj[0]);
        }
        return false;
    }
}

