/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.stat.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.common.config.stats.ToolSpecificConfig;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ToolSpecificStat
extends StatBase<ToolSpecificConfig> {
    public List<Item> supports = new ArrayList<Item>();

    public ToolSpecificStat(int id, String key, int limit) {
        super(id, key, limit);
        Collections.addAll(this.supports, this.getDefaultSupportedItems());
    }

    public abstract String getConfigurationKey();

    public abstract Item[] getDefaultSupportedItems();

    @Override
    public ToolSpecificConfig createConfig(ForgeConfigSpec.Builder builder) {
        ToolSpecificConfig config = new ToolSpecificConfig(builder);
        return config;
    }

    public void addSupportForItem(ItemStack item) {
        this.supports.add(item.func_77973_b());
    }

    public void removeSupportForItem(ItemStack item) {
        this.supports.remove(item.func_77973_b());
    }

    public boolean isItemSupported(ItemStack item) {
        return this.supports.contains(item.func_77973_b());
    }

    @Override
    public boolean isEffectiveOn(Object ... obj) {
        if (obj[0] != null && obj[0] instanceof ItemStack) {
            ItemStack item = (ItemStack)obj[0];
            return this.isItemSupported(item);
        }
        return false;
    }

    @Override
    public float getAppliedBonus(PlayerEntity player, Object object) {
        if (this.isEffectiveOn(object)) {
            return this.getBonus(player);
        }
        return 0.0f;
    }
}

