/*
 * Decompiled with CFR 0.152.
 */
package net.infstudio.goki.common.utils;

import java.util.Collection;
import java.util.function.IntFunction;
import net.infstudio.goki.api.capability.CapabilityStat;
import net.infstudio.goki.api.stat.StatBase;
import net.infstudio.goki.api.stat.StatStorage;
import net.infstudio.goki.common.config.GokiConfig;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;

public class DataHelper {
    public static boolean canPlayerRevertStat(PlayerEntity player, StatBase stat) {
        return (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() == -1 || (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() >= 0 && DataHelper.getPlayerRevertStatLevel(player, stat) < (Integer)GokiConfig.SERVER.globalMaxRevertLevel.get() && DataHelper.getPlayerStatLevel(player, stat) > 0;
    }

    public static int getPlayerRevertStatLevel(PlayerEntity player, StatBase stat) {
        if (player.getCapability(CapabilityStat.STAT).isPresent()) {
            return ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).revertedLevel;
        }
        throw new RuntimeException(new IllegalAccessException("Player " + player.func_208017_dF().func_150254_d() + " is missing stat capability!"));
    }

    public static void setPlayerRevertStatLevel(PlayerEntity player, StatBase stat, int level) {
        if (!player.getCapability(CapabilityStat.STAT).isPresent()) {
            throw new RuntimeException(new IllegalAccessException("Player " + player.func_208017_dF().func_150254_d() + " is missing stat capability!"));
        }
        ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).revertedLevel = level;
    }

    public static int getPlayerStatLevel(PlayerEntity player, StatBase stat) {
        if (player.getCapability(CapabilityStat.STAT).isPresent()) {
            return ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).level;
        }
        throw new RuntimeException(new IllegalAccessException("Player " + player.func_208017_dF().func_150254_d() + " is missing stat capability!"));
    }

    public static void setPlayerStatLevel(PlayerEntity player, StatBase stat, int level) {
        if (!player.getCapability(CapabilityStat.STAT).isPresent()) {
            throw new RuntimeException(new IllegalAccessException("Player " + player.func_208017_dF().func_150254_d() + " is missing stat capability!"));
        }
        ((StatStorage)player.getCapability(CapabilityStat.STAT).orElse((Object)new StatStorage())).stateMap.get((Object)stat).level = level;
    }

    public static void multiplyPlayerStatLevel(PlayerEntity player, StatBase stat, IntFunction<Integer> multiplier) {
        DataHelper.setPlayerStatLevel(player, stat, multiplier.apply(DataHelper.getPlayerStatLevel(player, stat)));
    }

    public static float trimDecimals(float in, int decimals) {
        float f = (float)((double)in * Math.pow(10.0, decimals));
        int i = (int)f;
        return (float)i / (float)Math.pow(10.0, decimals);
    }

    public static void setPlayersExpTo(PlayerEntity player, int total) {
        player.field_71106_cc = 0.0f;
        player.field_71068_ca = 0;
        player.field_71067_cb = 0;
        player.func_195068_e(total);
    }

    public static int getXPTotal(int xpLevel, float current) {
        return (int)((float)DataHelper.getXPValueFromLevel(xpLevel) + (float)DataHelper.getXPValueToNextLevel(xpLevel) * current);
    }

    public static int getXPTotal(PlayerEntity player) {
        return player.field_71067_cb;
    }

    public static boolean hasDamageModifier(ItemStack stack) {
        Collection modifiers = stack.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, stack).get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
        return modifiers != null && !modifiers.isEmpty();
    }

    public static int getXPValueFromLevel(int xpLevel) {
        int val = xpLevel > 31 ? (int)(4.5 * Math.pow(xpLevel, 2.0) - 162.5 * (double)xpLevel + 2220.0) : (xpLevel > 16 ? (int)(2.5 * Math.pow(xpLevel, 2.0) - 40.5 * (double)xpLevel + 360.0) : (int)(Math.pow(xpLevel, 2.0) + 6.0 * (double)xpLevel));
        return val;
    }

    public static int getXPValueToNextLevel(int xpLevel) {
        int val = xpLevel > 30 ? 9 * xpLevel - 158 : (xpLevel > 15 ? 5 * xpLevel - 38 : 2 * xpLevel + 7);
        return val;
    }

    public static float getDamageDealt(PlayerEntity player, Entity target, DamageSource source) {
        float damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        float bonusDamage = 0.0f;
        boolean targetIsLiving = target instanceof LivingEntity;
        ItemStack stack = player.func_184614_ca();
        if (targetIsLiving) {
            bonusDamage = EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)target).func_70668_bt());
        }
        if (damage > 0.0f || bonusDamage > 0.0f) {
            boolean critical;
            boolean bl = critical = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && player.func_184187_bx() == null && targetIsLiving;
            if (critical && damage > 0.0f) {
                damage *= 1.5f;
            }
            damage += bonusDamage;
        }
        return damage;
    }

    public static float getFallResistance(LivingEntity entity) {
        float resistance = 3.0f;
        EffectInstance potionEffect = entity.func_70660_b(Effects.field_76430_j);
        float bonus = potionEffect != null ? (float)(potionEffect.func_76458_c() + 1) : 0.0f;
        return resistance + bonus;
    }
}

